% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_diagnostics.R
\name{lpdtrace}
\alias{lpdtrace}
\title{Trace plot of log posterior density or log likelihood from an angmcmc object}
\usage{
lpdtrace(object, use.llik = FALSE, burnin = 1/3, thin = 1)
}
\arguments{
\item{object}{angular MCMC object.}

\item{use.llik}{logical. Should log likelihood be plotted instead of log posterior? Set
to \code{FALSE} by default.}

\item{burnin}{initial fraction of the MCMC samples to be discarded as burn-in. Must be a value in [0, 1).}

\item{thin}{positive integer. If \code{thin =} \eqn{n}, only every \eqn{n}-th realizations of the Markov chain is kept.}
}
\description{
Trace plot of log posterior density or log likelihood from an angmcmc object
}
\examples{
# first fit a vmsin mixture model
# illustration only - more iterations needed for convergence
fit.vmsin.20 <- fit_vmsinmix(tim8, ncomp = 3, n.iter =  20,
                             ncores = 1)
# log posterior density trace
lpdtrace(fit.vmsin.20)
# log likelihood trace
lpdtrace(fit.vmsin.20, use.llik = TRUE)

}

