% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_methods.R
\name{create_kusto_cluster}
\alias{create_kusto_cluster}
\alias{create_azure_data_explorer}
\title{Create Kusto/Azure Data Explorer cluster}
\description{
Method for the \link[AzureRMR:az_resource_group]{AzureRMR::az_resource_group} class.
}
\section{Usage}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{create_kusto_cluster(name, location,
                     node_size="D14_v2", ...)
}\if{html}{\out{</div>}}
}

\section{Arguments}{

\itemize{
\item \code{name}: The name of the cluster.
\item \code{location}: The location/region in which to create the account. Defaults to the resource group location.
\item \code{node_size}: The capacity of the nodes in each of the cluster. Defaults to "D14_v2", which should be available in all regions. The availability of other sizes depends on the region the cluster is created in.
\item ... Other named arguments to pass to the \link{az_kusto} initialization function.
}
}

\section{Details}{

This method deploys a new Kusto cluster resource, with parameters given by the arguments.
}

\section{Value}{

An object of class \code{az_kusto} representing the created cluster.
}

\examples{
\dontrun{

rg <- AzureRMR::get_azure_login("myaadtenant")$
    get_subscription("subscription_id")$
    get_resource_group("rgname")

# create a new Kusto cluster
rg$create_kusto_cluster("mykusto", node_size="L16")

}
}
\seealso{
\link{get_kusto_cluster}, \link{delete_kusto_cluster}, \link{az_kusto}

\href{https://docs.microsoft.com/en-us/azure/data-explorer/}{Kusto/Azure Data Explorer documentation}
}
