% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Object.R
\name{names<-,Andromeda-method}
\alias{names<-,Andromeda-method}
\title{Set table names in an Andromeda object}
\usage{
\S4method{names}{Andromeda}(x) <- value
}
\arguments{
\item{x}{An Andromeda object}

\item{value}{A character vector with the same length as the number of tables in x}
}
\description{
names(andromedaObject) must be set to a character vector with length equal to the number of
tables in the andromeda object (i.e. length(andromedaObject)). The user is
responsible for setting valid table names (e.g. not using SQL keywords or numbers as names)
This function treats Andromeda table names as case insensitive so if the only difference
between the new names and old names is the case then the names will not be changed.
}
\examples{
andr <- andromeda(cars = cars, iris = iris)
names(andr) <- c("CARS", "IRIS")
names(andr)
# [1] "CARS" "IRIS"
close(andr)

}
