% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ps_plot.R
\name{ps_plot}
\alias{ps_plot}
\title{Pollen Season Plot}
\usage{
ps_plot(data, pollen.type = NULL, year = NULL, export.plot = TRUE,
  export.format = "pdf", days = 30, fill.col = "turquoise4",
  export.width = 6, export.height = 6, int.method = "lineal",
  axisname = expression(paste("Pollen grains / m"^"3")), ...)
}
\arguments{
\item{data}{A \code{data.frame} object including the general database where interpollation must be performed. This \code{data.frame} must include a first column in \code{Date} format and the rest of columns in \code{numeric} format. Each column must contain information of one pollen type. It is not necessary to insert missing gaps; the function will automatically detect them.}

\item{pollen.type}{A \code{character} string specifying the name of the pollen type which will be plotted. The name must be exactly the same that appears in the column name. Mandatory argument with no default.}

\item{year}{A \code{numeric (interger)} value specifying the season to be plotted. The season does not necessary fit a natural year. See \code{\link{calculate_ps}} for more details. Mandatory argument with no default.}

\item{export.plot}{A \code{logical} argument. If \code{TRUE}, the graph created will be exported in a new folder (\emph{"plot_AeRobiology"}) in your working directory. The \code{export.plot} argument will be \code{TRUE} by default.}

\item{export.format}{A \code{character} string specifying the extension of the file in which the graph will be saved. The implemented extensions that can be used are: \code{"pdf", "png", "bmp", "jpeg"} and \code{"tiff"}. See \code{\link[ggplot2]{ggsave}} function for more details. Only valid if \code{export.plot = TRUE}. The \code{export.format} argument will be \code{"pdf"} by default.}

\item{days}{A \code{numeric (interger)} specifying the number of days beyond each side of the main pollen season that will be represented. The \code{days} argument will be \code{30} by default.}

\item{fill.col}{A \code{character} string specifying the name of the color to fill the main pollen season (Galan et al., 2017) in the plot. See \code{\link[ggplot2]{ggplot}} function for more details. The \code{fill.col} argument will be \code{"turquoise4"} by default.}

\item{export.width}{A \code{numeric (double)} value specifying the width of the graph in inches. Only valid if \code{export.plot = TRUE}. See \code{\link[ggplot2]{ggsave}} function for more details. The \code{export.width} argument will be \code{6} by default.}

\item{export.height}{A \code{numeric (double)} value specifying the height of the graph in inches. Only valid if \code{export.plot = TRUE}. See \code{\link[ggplot2]{ggsave}} function for more details. The \code{export.width} argument will be \code{6} by default.}

\item{int.method}{A \code{character} string specifying the method selected to apply the interpolation method in order to complete the pollen series. The implemented methods that may be used are: \code{"lineal"},  \code{"movingmean"}, \code{"spline"} or  \code{"tseries"}. See \code{\link{interpollen}} function for more details. The \code{int.method} argument will be \code{"lineal"} by default.}

\item{axisname}{A \code{character} string or an expression specifying the y axis title of the plot. The \code{axisname} argument will be \code{expression(paste("Pollen grains / m" ^ "3"))} by default.}

\item{...}{Other arguments passed on to the pollen season calculation as specified in \code{\link{calculate_ps}} function.}
}
\value{
The gunction returns an object of class \code{\link[ggplot2]{ggplot}} with a graphical representation of the main pollen season of the selected pollen type. The pre_peak and post_peak periods are marked with different color intensity. If \code{export.plot = TRUE}, the graph will be exported into \emph{"plot_AeRobiology"} folder (created in the working directory). The extension of the file will be the specified by \code{export.format} argument.
}
\description{
Function to plot the main pollen season of a single pollen type.
}
\details{
\code{ps_plot} function is designed to easily plot the main pollen season (Galan et al., 2017). The pre_peak period and the post_peak period are marked with different color intensity in the graph. The user must choose a single pollen type and season to plot.
}
\examples{
data("munich")
ps_plot(munich, year = 2013, pollen.type = "Betula", export.plot = FALSE)
}
\references{
Galan, C., Ariatti, A., Bonini, M., Clot, B., Crouzy, B., Dahl, A., Fernandez_Gonzalez, D., Frenguelli, G., Gehrig, R., Isard, S., Levetin, E., Li, D.W., Mandrioli, P., Rogers, C.A., Thibaudon, M., Sauliene, I., Skjoth, C., Smith, M., Sofiev, M., 2017. Recommended terminology for aerobiological studies. Aerobiologia (Bologna). 293_295.
}
\seealso{
\code{\link{calculate_ps}}, \code{\link{interpollen}}, \code{\link[ggplot2]{ggplot}}, \code{\link[ggplot2]{ggsave}}
}
