% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onlyDeconAlgorithms.R
\name{estCellPercent.nnls}
\alias{estCellPercent.nnls}
\title{Use non-negative least squares regression to deconvolve a sample
    This is going to be to simple to be useful
    This might be more interesting if I used non-positive least squares to detect 'other'}
\usage{
estCellPercent.nnls(refExpr, geneExpr)
}
\arguments{
\item{refExpr}{a data frame representing immune cell expression profiles. Each row represents an expression of a gene, and each column represents a different immune cell type. colnames contains the name of each immune cell type and the rownames includes the genes' symbol. The names of each immune cell type and the symbol of each gene should be unique. Any gene with missing expression values must be excluded.}

\item{geneExpr}{a data frame representing RNA-seq or microarray gene-expression profiles of a given complex tissue. Each row represents an expression of a gene, and each column represents a different experimental sample. colnames contain the name of each sample and rownames includes the genes' symbol. The name of each individual sample and the symbol of each gene should be unique. Any gene with missing expression values should be excluded.}
}
\value{
A matrix with cell type estimates for each samples
}
\description{
Use non-negative least squares regression to deconvolve a sample
    This is going to be to simple to be useful
    This might be more interesting if I used non-positive least squares to detect 'other'
}
\examples{
#This toy example 
library(ADAPTS)
fullLM22 <- ADAPTS::LM22[1:30, 1:4]
smallLM22 <- fullLM22[1:25,] 

cellEst <- estCellPercent.nnls(refExpr=smallLM22, geneExpr=fullLM22)
}
