% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wkrig_gd.R
\name{wkrig_gd}
\alias{wkrig_gd}
\title{Krige moving window maps with variogram selection}
\usage{
wkrig_gd(
  r,
  grd = NULL,
  weight_r = NULL,
  models = c("Sph", "Exp", "Gau", "Mat"),
  nmax = Inf,
  maxdist = Inf,
  psill_start = NULL,
  nugget_start = NULL,
  range_start = NULL,
  max_range_frac = 0.5,
  fit_method = 6,
  model_output = FALSE
)
}
\arguments{
\item{r}{SpatRaster produced by \link[wingen]{window_gd}. Only the first layer is used if multiple layers are present.}

\item{grd}{Object to create grid for kriging; can be a SpatRaster or RasterLayer. If undefined, \code{r} is used to create a grid.}

\item{weight_r}{Optional \link[terra]{SpatRaster} with sample counts per cell, used to compute location-specific measurement variance and weights for kriging. If \code{NULL} (default), no weighting is applied.}

\item{models}{Character vector of variogram model names to try (default: \code{c("Sph", "Exp", "Gau", "Mat")}).}

\item{nmax}{Integer. Maximum number of neighboring observations to use for kriging at each prediction location (default: \code{Inf}). Users are encouraged to experiment with \code{nmax} to balance smoothness and local detail; starting with a value of 30 is recommended to reduce computational cost while still capturing local variability.}

\item{maxdist}{Maximum distance to consider for neighboring observations (default: \code{Inf}). If set together with \code{nmax}, both parameters limit the number of neighbors.}

\item{psill_start}{Optional starting value for partial sill. If \code{NULL} (default), a heuristic value is used (see Note).}

\item{nugget_start}{Optional starting value for nugget effect. If \code{NULL} (default), a heuristic value is used (see Note).}

\item{range_start}{Optional starting value for range parameter. If \code{NULL} (default), a heuristic value is used (see Note).}

\item{max_range_frac}{Numeric. Maximum fraction of the range parameter to consider for neighboring observations (default: 0.5). This can help to limit the influence of distant points.}

\item{fit_method}{Integer. Variogram fitting method passed to \link[gstat]{fit.variogram}:
1 = weights N_j;
2 = weights N_j / gamma(h_j)^2;
6 = Ordinary Least Squares (unweighted);
7 = weights N_j / h_j^2.
The default (6) uses OLS, which is generally more robust for small or noisy datasets (see Note).}

\item{model_output}{Logical. If \code{TRUE}, returns a list with the prediction raster, variogram, and fitted variogram model. If \code{FALSE} (default), returns only the prediction raster.}
}
\value{
A \link[terra]{SpatRaster} object of kriged predictions if \code{model_output = FALSE}. If \code{model_output = TRUE}, returns a list with:
\describe{
\item{raster}{Kriged prediction raster (\link[terra]{SpatRaster})}
\item{variogram}{Empirical variogram (\link[gstat]{variogram})}
\item{model}{Best-fit variogram model (\link[gstat]{vgm})}
}
}
\description{
Perform ordinary kriging of the raster(s) produced by \link[wingen]{window_gd} using the gstat package to fit variograms and perform model selection. This function replaces the older \link[wingen]{krig_gd} function to provide more flexibility in variogram model selection. While the default parameters have not been formally validated, they have performed well in practice for kriging \code{wingen} outputs from both simulated and empirical datasets.
}
\details{
The function fits multiple variogram models (Spherical, Exponential, Gaussian, Matern by default) and selects the best fit based on SSErr. It also includes optional weighting to account for sample count variation.

By default, starting values for variogram parameters are set heuristically:
\itemize{
\item partial sill = ~80\% of global variance
\item nugget = ~20\% of global variance
\item range = 50\% of maximum pairwise distance
}

The variogram fitting method defaults to Ordinary Least Squares (\code{fit_method = 6}), which tends to produce more stable fits in noisy or irregular datasets. Weighted methods (1, 2, and 7) may offer improved accuracy in large, well-distributed datasets.

For more fine-scale control over variogram fitting and kriging, consult the \code{gstat} package documentation.

This function uses \link[gstat]{gstat} for variogram fitting and kriging. Weights are computed as the inverse of estimated location-specific variance (\eqn{\sigma^2 / n}) if sample counts are provided.
}
\note{
\strong{Convergence warnings from \code{gstat::fit.variogram()}}

During variogram fitting, you may see:

\if{html}{\out{<div class="sourceCode">}}\preformatted{Warning: No convergence after 200 iterations: try different initial values?
}\if{html}{\out{</div>}}

This means the optimizer reached its iteration limit before fully minimizing the error. Even in these cases, \code{gstat} returns the best-fit model found so far. Warnings often occur with small datasets or noisy empirical variograms. You can experiment with different \code{psill_start}, \code{range_start}, and \code{nugget_start} values, or increase the iteration limit using \code{options(gstat.fit.maxiter)}.
}
\examples{
# Note: this toy example uses a very small dataset.
# Warnings may occur due to limited points for variogram fitting.
suppressWarnings({
  load_mini_ex()
  wpi <- window_gd(mini_vcf, mini_coords, mini_lyr, L = 10, rarify = TRUE)
  kpi <- wkrig_gd(wpi[["pi"]], grd = mini_lyr, nugget = 0)
  plot_gd(kpi, main = "Kriged Pi")
})
}
