% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webhook.R
\name{whapi_log_plumber_req}
\alias{whapi_log_plumber_req}
\title{Log details of a Plumber request object using the cli package}
\usage{
whapi_log_plumber_req(
  req,
  show_headers = TRUE,
  show_cookies = TRUE,
  show_body = TRUE,
  max_chars = 2000L
)
}
\arguments{
\item{req}{A Plumber request object, usually passed automatically inside an endpoint.
Must contain fields such as \code{REQUEST_METHOD}, \code{PATH_INFO}, \code{HTTP_HOST}, etc.}

\item{show_headers}{Logical. Whether to print request headers (default: \code{TRUE}).
Sensitive values are redacted.}

\item{show_cookies}{Logical. Whether to print cookies (default: \code{TRUE}).
Values are always redacted.}

\item{show_body}{Logical. Whether to print the parsed body or raw \code{postBody} (default: \code{TRUE}).
Useful for debugging JSON payloads.}

\item{max_chars}{Integer. Maximum number of characters to print for large JSON or raw bodies.
Defaults to \code{2000}.}
}
\value{
Invisibly returns \code{NULL}. The function is called for its side-effect
of printing formatted logs to the console.
}
\description{
Prints a structured summary of a \code{req} object (Plumber request) to the console,
with colored and formatted output using the \strong{cli} package.
This helper is useful for debugging APIs, inspecting request metadata,
and logging incoming payloads in a readable way.

The function logs:
\itemize{
\item HTTP method, path, query string, host, client IP/port, content type, and length.
\item Parsed arguments: \code{argsQuery}, \code{argsBody}, \code{args}.
\item Headers (with sensitive values redacted).
\item Cookies (always redacted).
\item Parsed request body (\code{req$body} or \code{req$postBody}).
}
}
\examples{
\dontrun{
# Inside a Plumber endpoint
#* @post /myendpoint
function(req, res) {
  whapi_log_plumber_req(req) # Prints nicely formatted info about the incoming request
  list(success = TRUE)
}

# Print only metadata, no headers/body
whapi_log_plumber_req(req, show_headers = FALSE, show_body = FALSE)
}
}
\seealso{
\code{\link[cli:cli_abort]{cli::cli_inform()}}, \code{\link[cli:cli_rule]{cli::cli_rule()}}, \code{\link[cli:cli_verbatim]{cli::cli_verbatim()}}
}
