% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vital.R
\name{vital}
\alias{vital}
\title{Create a vital object}
\usage{
vital(
  ...,
  key = NULL,
  index,
  .age = NULL,
  .sex = NULL,
  .deaths = NULL,
  .births = NULL,
  .population = NULL,
  regular = TRUE,
  .drop = TRUE
)
}
\arguments{
\item{...}{A set of name-value pairs}

\item{key}{Variable(s) that uniquely determine time indices. NULL for empty key,
and \code{\link[=c]{c()}} for multiple variables. It works with tidy selector
(e.g. \code{\link[tidyselect:starts_with]{tidyselect::starts_with()}})}

\item{index}{A variable to specify the time index variable.}

\item{.age}{Character string with name of age variable}

\item{.sex}{Character string with name of sex variable}

\item{.deaths}{Character string with name of deaths variable}

\item{.births}{Character string with name of births variable}

\item{.population}{Character string with name of population variable}

\item{regular}{Regular time interval (\code{TRUE}) or irregular (\code{FALSE}). The interval
is determined by the greatest common divisor of index column, if \code{TRUE}.}

\item{.drop}{If \code{TRUE}, empty key groups are dropped.}
}
\value{
A tsibble with class \code{vital}.
}
\description{
A vital object is a type of tsibble that contains vital statistics such as
births, deaths, and population counts, and mortality and fertility rates.
It is a tsibble with a special class that allows for special methods to be used.
The object has an attribute that stores variables names needed for some functions,
including age, sex, births, deaths and population.
}
\examples{
# create a vital with only age as a key
vital(
  year = rep(2010:2015, 100),
  age = rep(0:99, each = 6),
  mx = runif(600, 0, 1),
  index = year,
  key = age,
  .age = "age"
)
}
\seealso{
\code{\link[tsibble:tsibble]{tsibble::tsibble()}}
}
\author{
Rob J Hyndman
}
