% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hfd.R
\name{read_hfd}
\alias{read_hfd}
\title{Read data directly from HFD and construct a \code{vital} object for use in other functions}
\usage{
read_hfd(country, username, password, variables = "asfrRR")
}
\arguments{
\item{country}{Directory abbreviation from the HMD. For instance, Norway = "NOR".}

\item{username}{HFD username (case-sensitive)}

\item{password}{HFD password (case-sensitive)}

\item{variables}{List of variables to download from the HFD. By default, the
age-specific fertility rate (asfrRR) is downloaded.}
}
\value{
\code{read_hfd} returns a \code{vital} object combining the downloaded data.
}
\description{
\code{read_hfd} reads single-year and single-age data from the Human Fertility Database (HFD
\url{https://www.humanfertility.org}) and constructs a \code{vital} object suitable
for use in other functions. This function uses \code{\link[HMDHFDplus:readHFDweb]{HMDHFDplus::readHFDweb()}}
to download the required data. It is designed to handle age-specific fertility rates.
It may be extended to handle other types of data in the future.
}
\details{
In order to read the data, users are required to create an account with the
HFD website (\url{https://www.humanfertility.org}), and obtain a valid username and password.
}
\examples{
\dontrun{
norway <- read_hfd(
  country = "NOR",
  username = "Nora.Weigh@mymail.com",
  password = "FF!5xeEFa6"
)
}
}
\author{
Rob J Hyndman
}
