% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_pr.R
\name{make_sd}
\alias{make_sd}
\title{Do a sum/difference transformation}
\usage{
make_sd(.data, .var, key = Sex)
}
\arguments{
\item{.data}{A vital object}

\item{.var}{A bare variable name of the measured variable to use.}

\item{key}{A bare variable name specifying the key variable to use.}
}
\value{
A vital object
}
\description{
Make a new vital containing means and differences of a measured variable by a
key variable. The most common use case of this function is for migration numbers by sex.
That is, we want to compute the age-specific mean migration, along
with the difference of migration to the mean for each sex. The latter
are equal to half the male/female and female/male differences of migration numbers.
}
\examples{
mig <- net_migration(norway_mortality, norway_births) |>
  dplyr::filter(Sex != "Total")
sd <- mig |>
  make_sd(NetMigration)
sd |>
  autoplot(NetMigration)
}
\references{
Hyndman, R.J., Booth, H., & Yasmeen, F. (2013). Coherent
mortality forecasting: the product-ratio method with functional time series
models. \emph{Demography}, 50(1), 261-283.
}
