% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggsave_vbracket.R
\name{ggsave_vbracket}
\alias{ggsave_vbracket}
\title{Save a ggplot with vbracket legend}
\usage{
ggsave_vbracket(
  filename,
  plot,
  device = NULL,
  width = NA,
  height = NA,
  units = c("in", "cm", "mm", "px"),
  dpi = 300,
  ...
)
}
\arguments{
\item{filename}{File name to save plot to}

\item{plot}{Plot to save (must have legend_bracket)}

\item{device}{Device to use (default auto-detects from filename)}

\item{width}{Width in units}

\item{height}{Height in units}

\item{units}{Units for width and height ("in", "cm", "mm", "px")}

\item{dpi}{DPI for raster devices}

\item{...}{Additional arguments passed to ggsave()}
}
\value{
No return value, called for its side effects. Saves the plot (including the vbracket legend, if present) to the file specified by \code{filename}.
}
\description{
This function is a wrapper around ggsave() that properly handles vbracket legends.
Use this instead of ggsave() when your plot has a legend_bracket().
}
\examples{
\donttest{
library(ggplot2)
data <- data.frame(x = 1:10, y = 1:10, group = rep(c("A", "B"), each = 5))
labels <- c("A", "B")
colors <- c("A" = "red", "B" = "blue")
comparisons <- add_bracket_comparisons(groups1 = "A", groups2 = "B", labels = "*")

p <- ggplot(data, aes(x, y, color = group)) +
  geom_point() +
  legend_bracket(labels, colors, comparisons,
                 position = "topleft", output_width = 6, output_height = 4)

ggsave_vbracket(file.path(tempdir(), "plot.pdf"), p, width = 6, height = 4)
}
}
