% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_arcs}
\alias{plot_arcs}
\title{Plot arcs between indexes of a Profile Index}
\usage{
plot_arcs(
  pairs,
  alpha = NULL,
  quality = 30,
  lwd = 15,
  col = c("blue", "orange"),
  main = "Arc Plot",
  ylab = "",
  xlab = "Profile Index",
  xmin = NULL,
  xmax = NULL,
  ...
)
}
\arguments{
\item{pairs}{a \code{matrix} with 2 columns.}

\item{alpha}{a \code{numeric}. (Default is \code{NULL}, automatic). Alpha value for lines transparency.}

\item{quality}{an \code{int}. (Default is \code{30}). Number of segments to draw the arc. Bigger value,
harder to render.}

\item{lwd}{an \code{int}. (Default is \code{15}). Line width.}

\item{col}{a \code{vector} of colors. (Default is \code{c("blue", "orange")}). Colors for right and left
arc, respectively. Accepts one color.}

\item{main}{a \code{string}. (Default is \code{"Arc Plot"}). Main title.}

\item{ylab}{a \code{string}. (Default is \code{""}). Y label.}

\item{xlab}{a \code{string}. (Default is \code{"Profile Index"}). X label.}

\item{xmin}{an \code{int}. (Default is \code{NULL}). Set the minimum value of x axis.}

\item{xmax}{an \code{int}. (Default is \code{NULL}). Set the maximum value of x axis.}

\item{\dots}{further arguments to be passed to \code{\link[=plot]{plot()}}. See \code{\link[=par]{par()}}.}
}
\value{
None
}
\description{
Sometimes may be useful to see where is the nearest neighbor graphically. This is the reasoning
behind, for example, FLUSS which uses the arc count to infer a semantic change, and SiMPle which
infer that arcs connect similar segments of a music. See details for a deeper explanation how to
use this function.
}
\details{
You have two options to use this function. First you can provide just the data, and the function
will try its best to retrieve the pairs for plotting. Second, you can skip the first parameters
and just provide the \code{pairs}, which is a \code{matrix} with two columns; the first is the starting
index, the second is the end index. Two colors are used to allow you to identify the direction of
the arc. If you use the \code{rpi} or \code{lpi} as input, you will see that these profile indexes have
just one direction.

\code{exclusion_zone} is used to filter out small arcs that may be useless (e.g. you may be interested
in similarities that are far away). \code{edge_limit} is used to filter out spurious arcs that are
used connect the beginning and the end of the profile (e.g. silent audio). \code{threshold} is used to
filter indexes that have distant nearest neighbor (e.g. retrieve only the best motifs).
}
\examples{
plot_arcs(pairs = matrix(c(5, 10, 1, 10, 20, 5), ncol = 2, byrow = TRUE))
}
\keyword{hplot}
