% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mass-pre.R
\name{mass_pre}
\alias{mass_pre}
\title{Precomputes several values used on MASS}
\usage{
mass_pre(data, query = NULL, window_size)
}
\arguments{
\item{data}{a \code{vector} or a \code{matrix} of \code{numeric}. Reference Time Series.}

\item{query}{a \code{vector} or a \code{matrix} of \code{numeric}. Query Time Series (default is \code{NULL}).}

\item{window_size}{an \code{int}. Sliding window size.}
}
\value{
Returns \code{window_size}, \code{data_fft}, \code{data_size}, \code{data_mean}, \code{data_sd}, \code{query_mean} and \code{query_sd}.
}
\description{
Precomputes several values used on MASS
}
\examples{
w <- mp_toy_data$sub_len
ref_data <- mp_toy_data$data[, 1]
query_data <- mp_toy_data$data[, 1]

pre <- tsmp:::mass_pre(ref_data, query_data, w)

dp <- list()
for (i in 1:(pre$data_size - w + 1)) {
  dp[[i]] <- tsmp:::mass_v2(
    query_data[i:(i - 1 + w)], pre$window_size, pre$data_fft, pre$data_size,
    pre$data_mean, pre$data_sd, pre$query_mean[i], pre$query_sd[i]
  )
}
}
\references{
\itemize{
\item Abdullah Mueen, Yan Zhu, Michael Yeh, Kaveh Kamgar, Krishnamurthy Viswanathan,
Chetan Kumar Gupta and Eamonn Keogh (2015), The Fastest Similarity Search Algorithm for Time
Series Subsequences under Euclidean Distance.
}

Website: \url{https://www.cs.unm.edu/~mueen/FastestSimilaritySearch.html}
}
\seealso{
\code{\link[=mass_v2]{mass_v2()}}, \code{\link[=mass_v3]{mass_v3()}} for using precomputed values.
}
\keyword{internal}
