% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_scale_.R
\name{tm_scale_intervals}
\alias{tm_scale_intervals}
\title{Scales: interval scale}
\usage{
tm_scale_intervals(
  n = 5,
  style = ifelse(is.null(breaks), "pretty", "fixed"),
  style.args = list(),
  breaks = NULL,
  interval.closure = "left",
  label.style = "discrete",
  label.select = TRUE,
  midpoint = NULL,
  as.count = FALSE,
  values = NA,
  values.repeat = FALSE,
  values.range = NA,
  values.scale = NA,
  value.na = NA,
  value.null = NA,
  value.neutral = NA,
  labels = NULL,
  label.na = NA,
  label.null = NA,
  label.format = tm_label_format()
)
}
\arguments{
\item{n}{Number of intervals. For some styles (see argument \code{style} below) it is the preferred number rather than the exact number.}

\item{style}{Method to create intervals. Options are \code{"cat"}, \code{"fixed"}, \code{"sd"}, \code{"equal"}, \code{"pretty"}, \code{"quantile"}, \code{"kmeans"}, \code{"hclust"}, \code{"bclust"}, \code{"fisher"}, \code{"jenks"}, \code{"dpih"}, \code{"headtails"}, and \code{"log10_pretty"}. See the details in \code{\link[classInt:classIntervals]{classInt::classIntervals()}} (extra arguments can be passed on via \code{style.args}).}

\item{style.args}{List of extra arguments passed on to \code{\link[classInt:classIntervals]{classInt::classIntervals()}}.}

\item{breaks}{Interval breaks (only used and required when \code{style = "fixed"})}

\item{interval.closure}{value that determines whether where the intervals are closed: \code{"left"} or \code{"right"}. If \code{as.count = TRUE}, \code{inverval.closure} is always set to \code{"left"}.}

\item{label.style}{Either \code{"discrete"} or \code{"continuous"}. If \code{discrete} (default) intervals will be labeled. If \code{continuous}, the legend will be similar to a continuous scale legend (but with discrete colors), where the breaks are labeled.}

\item{label.select}{Which labels are shown? A logical vector is expected, which is repeated along the number of labels. By default \code{TRUE}, which means all.}

\item{midpoint}{The data value that is interpreted as the midpoint. By default it is set to 0 if negative and positive values are present. Useful when values are diverging colors. In that case, the two sides of the color palette are assigned to negative respectively positive values. If all values are positive or all values are negative, then the midpoint is set to \code{NA}, which means that the value that corresponds to the middle color class (see \code{style}) is mapped to the middle color. If it is specified for sequential color palettes (e.g. \code{"Blues"}), then this color palette will be treated as a diverging color palette.}

\item{as.count}{Should the data variable be processed as a count variable? For instance, if \code{style = "pretty"}, \code{n = 2}, and the value range of the variable is 0 to 10, then the column classes for \code{as.count = TRUE} are 0; 1 to 5; 6 to 10 (note that 0 is regarded as an own category) whereas for \code{as.count = FALSE} they are 0 to 5; 5 to 10. Only applicable if \code{style} is \code{"pretty"}, \code{"fixed"}, or \code{"log10_pretty"}. By default \code{FALSE}.}

\item{values}{(generic scale argument) The visual values. For colors (e.g. \code{fill} or \code{col} for \code{\link[=tm_polygons]{tm_polygons()}}) this is a palette name from the \code{cols4all} package (see \code{\link[cols4all:c4a]{cols4all::c4a()}}) or vector of colors, for size (e.g. \code{size} for \code{tm_symbols}) these are a set of sizes (if two values are specified they are interpret as range), for symbol shapes (e.g. \code{shape} for \code{tm_symbols}) these are a set of symbols, etc. The tmap option \code{values.var} contains the default values per visual variable and in some cases also per data type.}

\item{values.repeat}{(generic scale argument) Should the values be repeated in case there are more categories?}

\item{values.range}{(generic scale argument) Range of the values. Vector of two numbers (both between 0 and 1) where the first determines the minimum and the second the maximum. Full range, which means that all values are used, is encoded as \code{c(0, 1)}. For instance, when a gray scale is used for color (from black to white), \code{c(0,1)} means that all colors are used, \verb{0.25, 0.75} means that only colors from dark gray to light gray are used (more precisely \code{"gray25"} to \code{"gray75"}), and \verb{0, 0.5} means that only colors are used from black to middle grey (\code{"grey50"}). When only one number is specified, this is interpreted as the second number (where the first is set to 0). Default values can be set via the tmap option \code{values.range}.}

\item{values.scale}{(generic scale argument) Scaling of the values. Only useful for size-related visual variables, such as \code{size} of \code{\link[=tm_symbols]{tm_symbols()}} and \code{lwd} of \code{\link[=tm_lines]{tm_lines()}}.}

\item{value.na}{(generic scale argument) Value used for missing values. See tmap option \code{"value.na"} for defaults per visual variable.}

\item{value.null}{(generic scale argument) Value used for NULL values. See tmap option \code{"value.null"} for defaults per visual variable. Null data values occur when out-of-scope features are shown (e.g. for a map of Europe showing a data variable per country, the null values are applied to countries outside Europe).}

\item{value.neutral}{(generic scale argument) Value that can be considered neutral. This is used for legends of other visual variables of the same map layer. E.g. when both \code{fill} and \code{size} are used for \code{\link[=tm_symbols]{tm_symbols()}} (using filled circles), the size legend items are filled with the \code{value.neutral} color from the \code{fill.scale} scale, and fill legend items are bubbles of size \code{value.neutral} from the \code{size.scale} scale.}

\item{labels}{(generic scale argument) Labels}

\item{label.na}{(generic scale argument) Label for missing values}

\item{label.null}{(generic scale argument) Label for null (out-of-scope) values}

\item{label.format}{(generic scale argument) Label formatting. Output of \code{\link[=tm_label_format]{tm_label_format()}}}
}
\description{
Scales in tmap are configured by the family of functions with prefix \code{tm_scale}.
Such function should be used for the input of the \code{.scale} arguments in the
layer functions (e.g. \code{fill.scale} in \code{\link[=tm_polygons]{tm_polygons()}}).
The function \code{tm_scale_intervals()} is used for numerical data.
}
\seealso{
\href{https://r-tmap.github.io/tmap/articles/basics_scales}{tmap basics: scales}

\code{\link[=tm_scale]{tm_scale()}}
}
