% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/um.R
\name{spec}
\alias{spec}
\alias{spec.um}
\title{Spectrum of an ARMA model}
\usage{
spec(um, ...)

\method{spec}{um}(um, nabla = FALSE, n.freq = 501, ...)
}
\arguments{
\item{um}{an object of class \code{um}.}

\item{...}{additional parameters.}

\item{nabla}{logical. If TRUE, the pseudospectrum for a non stationary ARIMA
model is calculated. By default, the spectrum is computed for the
stationary ARMA model.}

\item{n.freq}{number of frequencies.}
}
\value{
A matrix with the frequencies and the power spectral densities.
}
\description{
\code{spec} computes the spectrum of an ARMA model.
}
\note{
The I polynomial is ignored.
}
\examples{
um1 <- um(i = "(1 - B)(1 - B^12)", ma = "(1 - 0.8B)(1 - 0.8B^12)")
s <- spec(um1, lag.max = 13)
}
