% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tfm.R, R/um.R
\name{setinputs.tfm}
\alias{setinputs.tfm}
\alias{setinputs}
\alias{setinputs.um}
\title{Add or Replace Inputs in Models}
\usage{
\method{setinputs}{tfm}(
  mdl,
  xreg = NULL,
  inputs = NULL,
  y = NULL,
  envir = parent.frame(),
  ...
)

setinputs(mdl, ...)

\method{setinputs}{um}(mdl, xreg = NULL, inputs = NULL, y = NULL, envir = NULL, ...)
}
\arguments{
\item{mdl}{A \code{um} or \code{tfm} object.}

\item{xreg}{Optional matrix of exogenous regressors.}

\item{inputs}{Optional list of \code{tf} objects (only for \code{tfm}).}

\item{y}{Optional \code{ts} object for output series.}

\item{envir}{Environment for evaluation. Default is calling environment.}

\item{...}{Additional arguments passed to model constructor.}
}
\value{
A \code{tfm} object.
}
\description{
Adds new inputs to transfer function or univariate models.
}
\details{
For \code{tfm} objects: If the model already has inputs of the same type,
new ones are appended (combined). The model is re-fitted by default unless
\code{fit = FALSE}.
}
\seealso{
\code{\link{um}}, \code{\link{tfm}}
}
