% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stsm.R, R/tfm.R, R/um.R
\name{calendar.ssm}
\alias{calendar.ssm}
\alias{calendar.tfm}
\alias{calendar}
\alias{calendar.um}
\title{Calendar effects}
\usage{
\method{calendar}{ssm}(
  mdl,
  form = c("dif", "td", "td7", "td6", "wd"),
  ref = 0,
  lom = TRUE,
  lpyear = TRUE,
  easter = FALSE,
  len = 4,
  easter.mon = FALSE,
  n.ahead = 0,
  p.value = 1,
  envir = NULL,
  ...
)

\method{calendar}{tfm}(
  mdl,
  y = NULL,
  form = c("dif", "td", "td7", "td6", "wd"),
  ref = 0,
  lom = TRUE,
  lpyear = TRUE,
  easter = FALSE,
  len = 4,
  easter.mon = FALSE,
  n.ahead = 0,
  p.value = 1,
  envir = parent.frame(),
  ...
)

calendar(mdl, ...)

\method{calendar}{um}(
  mdl,
  y = NULL,
  form = c("dif", "td", "td7", "td6", "wd"),
  ref = 0,
  lom = TRUE,
  lpyear = TRUE,
  easter = FALSE,
  len = 4,
  easter.mon = FALSE,
  n.ahead = 0,
  p.value = 1,
  envir = parent.frame(),
  ...
)
}
\arguments{
\item{mdl}{an object of class \code{\link{um}} or \code{\link{tfm}}.}

\item{form}{representation for calendar effects: (1) \code{form = dif}, L,
D1-D0, ..., D6-D0; (2) \code{form = td}, LPY, D1-D0, ..., D6-D0; (3)
\code{form = td7}, D0, D2, ..., D6; (4) \code{form = td6}, D1, D2, ..., D6;
(5) \code{form = wd}, (D1+...+D5) - 2(D6+D0)/5.}

\item{ref}{a integer indicating the the reference day. By default, ref = 0.}

\item{lom, lpyear}{a logical value indicating whether or not to include the
lom/lead year indicator.}

\item{easter}{logical. If \code{TRUE} an Easter effect is also estimated.}

\item{len}{the length of the Easter, integer.}

\item{easter.mon}{logical. TRUE indicates that Easter Monday is a public
holiday.}

\item{n.ahead}{a positive integer to extend the sample period of the
deterministic variables with \code{n.ahead} observations, which could be
necessary to forecast the output.}

\item{p.value}{estimates with a p-value greater than p.value are omitted.}

\item{envir}{environment in which the function arguments are evaluated. If
NULL the calling environment of this function will be used.}

\item{...}{other arguments.}

\item{y}{a time series.}
}
\value{
An object of class "\code{\link{tfm}}".
}
\description{
\code{calendar} extends the ARIMA model \code{um} by including a set of
deterministic variables to capture the calendar variation in a monthly time
series. Two equivalent representations are available: (i) D0, D1, ..., D6,
(ii) L, D1-D0, ..., D6-D0 where D0, D2, ..., D6 are deterministic variables
representing the number of Sundays, Mondays, ..., Saturdays, L = D0 + D1 + ...
+ D6 is the of the month. Alternatively, the Leap Year indicator (LPY) can be
included instead of L. The seven trading days can also be compacted into two
variables: week days and weekends. Optionally, a deterministic variable to
estimate the Easter effect can also be included, see "\code{\link{easter}}".
}
\examples{
data(rsales)
um1 <- um(rsales, i = list(1, c(1, 12)), ma = list(1, c(1, 12)), bc = TRUE)
tfm1 <- calendar(um1)

}
\references{
W. R. Bell & S. C. Hillmer (1983) Modeling Time Series with
 Calendar Variation, Journal of the American Statistical Association, 78:383,
 526-534, DOI: 10.1080/01621459.1983.10478005
}
