% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detvar.R
\name{CalendarVar}
\alias{CalendarVar}
\title{Calendar variables}
\usage{
CalendarVar(
  x,
  form = c("dif", "td", "td7", "td6", "wd", "null"),
  ref = 0,
  lom = TRUE,
  lpyear = TRUE,
  easter = FALSE,
  len = 4,
  easter.mon = FALSE,
  n.ahead = 0
)
}
\arguments{
\item{x}{A `ts` object used to determine start, length and frequency.}

\item{form}{Character selecting the set of calendar variables: `"dif"`
(differences wrt reference day), `"td"` (6 dummies + lom; omits reference),
`"td7"` (7 dummies), `"td6"` (6 dummies; omits reference), `"wd"` (weekdays
vs weekend), or `"null"` (no trading-day regressors).}

\item{ref}{Non-negative integer (0–6) indicating the reference day (0 =
Sunday, 1 = Monday, …, 6 = Saturday). Ignored unless `form` needs it.}

\item{lom}{Logical. If `TRUE` include a length-of-month regressor.}

\item{lpyear}{Logical. If `TRUE` include a leap-year regressor.}

\item{easter}{Logical. If `TRUE` include an Easter regressor.}

\item{len}{Integer duration for Easter effect (days). Typical values: 4–8.}

\item{easter.mon}{Logical. `TRUE` if Holy Monday is a public holiday.}

\item{n.ahead}{Integer. Extra observations to extend the sample (forecast
horizon).}
}
\value{
An object of class `ts` or `mts` with the requested regressors.
}
\description{
`CalendarVar()` creates a set of deterministic regressors to capture calendar
effects (trading/working days, length-of-month, leap-year and Easter).
}
\examples{
X <- CalendarVar(AirPassengers, form = "wd", easter = TRUE, len = 5)

}
\references{
Bell, W.R. and Hillmer, S.C. (1983) “Modeling time series with
  calendar variation”, *Journal of the American Statistical Association*, 78,
  526–534.
}
