% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poppk_mods.R
\name{pkmod_marsh}
\alias{pkmod_marsh}
\title{-----------------------------------------------------------------------------
Population PK and PK-PD functions -------------------------------------------
-----------------------------------------------------------------------------
Marsh population PK model for propofol}
\usage{
pkmod_marsh(TBW, ...)
}
\arguments{
\item{TBW}{Weight (kg)}

\item{...}{Arguments passed to `pkmod`}
}
\value{
`pkmod` object with Marsh population PK parameters
}
\description{
Evaluates the Marsh propofol model at patient covariates (total body mass) and
returns a `pkmod` object. KE0 parameter set to 1.2 in accordance with recommendations
from Absalom et al., 2009 "Pharmacokinetic models for propofol- Defining and
illuminating the devil in the detail."
}
\examples{
pkmod_marsh(TBW = 50)
}
