% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{swaglm}
\alias{swaglm}
\title{swaglm}
\usage{
swaglm(
  X,
  y,
  p_max = 2L,
  family = NULL,
  method = 0L,
  alpha = 0.3,
  verbose = FALSE,
  seed = 123L
)
}
\arguments{
\item{X}{A numeric \code{matrix} of predictors.}

\item{y}{A numeric \code{vector} of responses.}

\item{p_max}{An \code{integer} specifying the maximum dimension to explore}

\item{family}{A \code{family} object. Default is binomial.}

\item{method}{An \code{integer} scalar with value 0 for the column-pivoted QR decomposition, 1 for the unpivoted QR decomposition, 2 for the LLT Cholesky, or 3 for the LDLT Cholesky. See \code{?fastglm::fastglm}}

\item{alpha}{A \code{double} specifying the quantile of the criterion used to select models which are employed to construct models to explore at the next dimension}

\item{verbose}{A \code{boolean} used to control verbose}

\item{seed}{An \code{integer} that is the random seed used when creating the set of model to explore for the next dimension}
}
\value{
An object of class \code{swaglm} structured as a \code{List} containing:
\itemize{
\item \code{lst_estimated_beta}: A \code{List} that contain the estimated coefficients for each estimated model. Each entry of this \code{List} is a matrix where in each rows are the estimated coefficients for the model.
\item \code{lst_p_value} A \code{List} that contain the p-value associated with each estimated coefficients for each estimated model. Each entry of this \code{List} is a matrix where in each rows are the p-value for the model.
\item \code{lst_AIC}: A \code{List} that contains the AIC values for each model at each dimension. Each entry of this list correspond to the AIC values for the models explored at this dimension.
\item \code{lst_var_mat}:  A \code{List} that that contain in each of its entries, a matrix that specify for each row a combination of variables that compose a model.
\item \code{lst_selected_models} A \code{List} that contain the selected models at each dimension.
\item \code{lst_index_selected_models} A \code{List} that contain the index of the rows corresponding to the selected models at each dimension.
\item \code{vec_selected_variables_dimension_1} A \code{vector} that contain the index of the selected variables at the screening step.
\item \code{y} The response vector used in the estimation.
\item \code{X} The predictor matrix used in the estimation.
\item \code{p_max} The maximum dimension explored by the algorithm.
\item \code{alpha} The selection quantile used at each step.
\item \code{family} The GLM family used in the estimation (e.g. \code{binomial()}).
\item \code{method} The method used by \code{fastglm} for estimation.
}
}
\description{
Run the SWAG algorithm on Generalized Linear Models specified by a \code{family} object and using the \code{fastglm} library.
}
\examples{
# Parameters for data generation
set.seed(12345)
n <- 2000
p <- 100
# create design matrix and vector of coefficients
Sigma <- diag(rep(1/p, p))
X <- MASS::mvrnorm(n = n, mu = rep(0, p), Sigma = Sigma)
beta = c(-15,-10,5,10,15, rep(0,p-5))

# --------------------- generate from logistic regression with an intercept of one
z <- 1 + X\%*\%beta
pr <- 1/(1 + exp(-z))
y <- as.factor(rbinom(n, 1, pr))
y = as.numeric(y)-1

# define swag parameters
quantile_alpha = .15
p_max = 20
swag_obj = swaglm::swaglm(X=X, y = y, p_max = p_max, family = stats::binomial(), 
alpha = quantile_alpha, verbose = TRUE, seed = 123)
str(swag_obj)

}
