% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_metrics.R
\name{texture_index}
\alias{texture_index}
\title{Texture index}
\usage{
texture_index(x, ...)
}
\arguments{
\item{x}{SpatRaster or matrix containing two values: -1 and 1}

\item{...}{Arguments for \code{\link[comat:get_coma]{comat::get_coma()}}}
}
\value{
A numeric vector
}
\description{
Calculates texture index -- an average (over an array) of a product of the values of neighboring cells.
The value of texture index is between 0 (fine texture), and 1 (coarse texture).
}
\examples{
data(r_start, package = "spatialising")
texture_index(r_start)
ts1 = kinetic_ising(r_start, B = -0.3, J = 0.7)
texture_index(ts1)
ts2 = kinetic_ising(r_start, B = -0.3, J = 0.7, updates = 2)
texture_index(ts2)

\donttest{
  library(terra)
  r1 = rast(system.file("raster/r_start.tif", package = "spatialising"))
  texture_index(r1)
  r2 = kinetic_ising(r1, B = -0.3, J = 0.7)
  texture_index(r2)
}
}
\seealso{
\code{\link[=kinetic_ising]{kinetic_ising()}}
}
