% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_tools.r
\name{prune.mca}
\alias{prune.mca}
\title{Remove unnecessary variables from an MCA}
\usage{
prune.mca(
  r,
  eigen.cut.off = 0.55,
  network.pruning = TRUE,
  average.pruning = FALSE,
  min.degree = 1
)
}
\arguments{
\item{r}{a result object from \link{soc.mca}}

\item{eigen.cut.off}{the cut.off for the first eigen value from \link{mca.eigen.check}}

\item{network.pruning}{If TRUE variables are pruned on the basis their degree}

\item{average.pruning}{If TRUE variables with a sum of ties below average are discarded. This}

\item{min.degree}{the minimum number of ties a variable has to have to remain in the analysis}
}
\value{
A list containing:
 \item{var}{a tibble with the weighted degree of the variables} 
 \item{mca.eigen.check}{The results from \link{mca.eigen.check}}
 \item{g}{a network graph - see \link[igraph]{igraph}}
 \item{remaining.var}{a character vector with the names of the remaining variables}
 \item{removed}{a character vector with the names of the removed variables}
 \item{pruned.r}{A pruned version of the original soc.mca object}
}
\description{
This function tests and removes variables that have no or too few relations with other variables. In other words variables that only contribute with random noise to the analysis. Removing these variables will tend to increase the strength of the first dimensions and give a wider dispersion of the cloud of cases on the first dimensions. Removing these variables can also give a simpler analysis that is easier to interpret and communicate. The core of the pruning procedure uses the \link{mca.eigen.check} to construct a weighted network of relations between variables. Tie strength is measured by the first eigenvalue of an MCA between the two variables. Ties between variables with a weak relationship  are removed and variables with few connections to other variables are discarded. With the default values a analysis without irrelevant variables is unchanged. Note that passive categories are inherited from the original analysis and are not included in the \link{mca.eigen.check}. This procedure does not help with variables that are too strongly related.
}
\examples{
example(soc.mca)      
pr <- prune.mca(result)  
pr$removed               # This example has no irrelevant variables so nothing is removed
}
\references{
Inspired by: Durand, Jean-Luc, and Brigitte Le Roux. 2018. “Linkage Index of Variables and its Relationship with Variance of Eigenvalues in PCA and MCA.” Statistica Applicata 29(2):123–35. doi: 10.26398/ijas.0029-006.
}
