% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmfit.R
\name{simulate.mmfit}
\alias{simulate.mmfit}
\title{Simulates Markov chains}
\usage{
\method{simulate}{mmfit}(object, nsim = 1, seed = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{mmfit}.}

\item{nsim}{An integer or vector of integers (for multiple sequences)
specifying the length of the sequence(s).}

\item{seed}{Optional. \code{seed} for the random number generator.
If no \code{seed} is given, then seed is set by using the command
\verb{set.seed(round(as.numeric(Sys.time()))}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A list of vectors representing the sequences.
}
\description{
Simulates sequences from a fitted Markov model.
}
\details{
If \code{nsim} is a single integer then a chain of that length is
produced. If \code{nsim} is a vector of integers, then \code{length(nsim)}
sequences are generated with respective lengths.
}
\seealso{
\link{mm}, \link{fitmm}
}
