% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rollingMax.R
\name{rollingMax}
\alias{rollingMax}
\title{Compute Rolling Max}
\usage{
rollingMax(mydata, length = 24)
}
\arguments{
\item{mydata}{A numeric vector of data values}

\item{length}{An integer specifying the window size (number of observations)
to consider. Must be at least 3 (default = 24).}
}
\value{
A numeric vector containing rolling maximum values, with same
dimensions as \code{mydata}.
}
\description{
The function computes the rolling maximum value along a time series.
}
\details{
It calculates the maximum over consecutive elements centered within a
specified window.

For each index i, it considers a window of \code{length} points centered around i.
When \code{length} is odd, the center falls exactly on i and the window extends
equally to both sides.
When \code{length} is even, the window extends one less point to the left than to
the right and the rolling max is not exactly centered.

Values near the start of the series use windows with fewer than \code{length}
data points if there are not enough preceding elements to form a full window.
Similarly for values at the end.
}
\examples{
# Compute rolling max over a 24-hour period on hourly time series data
data(stMeteo)
ws_24h <- rollingMax(mydata = stMeteo$ws, length = 24)

}
