% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simIC.R
\name{simIC}
\alias{simIC}
\title{Simulate Interval-, Left-, Right-, and Uncensored Survival Data}
\usage{
simIC(
  n = 100,
  dist = "weibull",
  shape = 2,
  scale = 1,
  meanlog = 0,
  sdlog = 1,
  location = 0,
  width = 1,
  visit_start = 0,
  study_start = NULL,
  study_end = NULL,
  uncensored_tol = 0.1
)
}
\arguments{
\item{n}{Number of samples.}

\item{dist}{Distribution name ("weibull", "exp", "lognormal", "loglogistic", "normal", "logistic", "EMV", "gamma", "gompertz").}

\item{shape, scale}{Distribution parameters for applicable distributions.}

\item{meanlog, sdlog}{For lognormal.}

\item{location}{For normal, logistic, and EMV.}

\item{width}{Visit interval width.}

\item{visit_start}{First visit time.}

\item{study_start}{Optional: left-censoring cutoff.}

\item{study_end}{Optional: right-censoring cutoff.}

\item{uncensored_tol}{Tolerance to treat (left, right) as exact event.}
}
\value{
A data frame with columns: id, left, right, true_time, censoring
}
\description{
Simulates survival data with optional left-censoring, right-censoring, and uncensoring thresholds.
}
\examples{
# Simulate 100 survival times from a log-normal distribution
set.seed(123)
data <- simIC(n = 100, dist = "lognormal", meanlog = 1.5, sdlog = 0.5, width = 2,
              study_start = 1, study_end = 8, uncensored_tol = 0.1)
head(data)
}
