% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dashboardControlbar.R
\name{dashboardControlbar}
\alias{dashboardControlbar}
\alias{updateControlbar}
\alias{controlbarMenu}
\alias{controlbarItem}
\alias{updateControlbarMenu}
\title{AdminLTE2 dashboard right sidebar}
\usage{
dashboardControlbar(
  ...,
  id = NULL,
  disable = FALSE,
  width = 230,
  collapsed = TRUE,
  overlay = TRUE,
  skin = "dark",
  .list = NULL
)

updateControlbar(id, session = shiny::getDefaultReactiveDomain())

controlbarMenu(..., id = NULL, selected = NULL)

controlbarItem(title, ..., value = title, icon = NULL)

updateControlbarMenu(
  id,
  selected = NULL,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{...}{slot for \link{controlbarMenu}. Not compatible with .items.}

\item{id}{Controlbar id.}

\item{disable}{If \code{TRUE}, the sidebar will be disabled.}

\item{width}{Sidebar width in pixels. Numeric value expected. 230 by default.}

\item{collapsed}{Whether the control bar on the right side is collapsed or not at start. TRUE by default.}

\item{overlay}{Whether the sidebar covers the content when expanded. Default to TRUE.}

\item{skin}{background color: "dark" or "light".}

\item{.list}{Pass element here if you do not want to embed them in panels. Not compatible with ...}

\item{session}{Shiny session object.}

\item{selected}{Item to select.}

\item{title}{Display title for tab}

\item{value}{The value that should be sent when \code{tabsetPanel} reports
that this tab is selected. If omitted and \code{tabsetPanel} has an
\code{id}, then the title will be used.}

\item{icon}{Optional icon to appear on the tab. This attribute is only
valid when using a \code{tabPanel} within a \code{\link[shiny:navbarPage]{navbarPage()}}.}
}
\description{
\link{dashboardControlbar} create a right sidebar container.

\link{updateControlbar} allows to toggle a \link{dashboardControlbar}.

\link{controlbarMenu} is a tabset panel for the \link{dashboardControlbar}.

\link{controlbarItem} is a tabPanel for the \link{controlbarMenu}.

\link{updateControlbarMenu} allows to programmatically change the currently
selected \link{controlbarItem} on the client.
}
\note{
Until a maximum of 5 \link{controlbarItem}! AdminLTE 2 does not
support more panels.
}
\examples{

# Controlbar example
if (interactive()) {
 library(shiny)
 library(shinydashboard)
 library(shinydashboardPlus)
 shinyApp(
   ui = dashboardPage(
     header = dashboardHeader(),
     sidebar = dashboardSidebar(),
     body = dashboardBody(),
     controlbar = dashboardControlbar(
      skin = "dark",
      controlbarMenu(
       id = "menu",
       controlbarItem(
        "Tab 1",
        "Welcome to tab 1"
       ),
       controlbarItem(
        "Tab 2",
        "Welcome to tab 2"
       )
      )
     ),
     title = "Right Sidebar"
   ),
   server = function(input, output) { }
 )
}

# Toggle the dashboard controlbar
if (interactive()) {
 library(shiny)
 library(shinydashboard)
 library(shinydashboardPlus)
 
 shinyApp(
   ui = dashboardPage(
     header = dashboardHeader(),
     sidebar = dashboardSidebar(),
     body = dashboardBody(
       actionButton(inputId = "controlbarToggle", label = "Toggle Controlbar")
     ),
     controlbar = dashboardControlbar(id = "controlbar")
   ),
   server = function(input, output, session) {
     
     observeEvent(input$controlbar, {
       if (input$controlbar) {
         showModal(modalDialog(
           title = "Alert",
           "The controlbar is opened.",
           easyClose = TRUE,
           footer = NULL
         ))
       }
     })
     
     observeEvent(input$controlbarToggle, {
       updateControlbar("controlbar")
     })
     
     observe({
       print(input$controlbar)
     })
   }
 )
}

# controlbar with controlbarMenu
if (interactive()) {
 library(shiny)
 library(shinydashboard)
 library(shinydashboardPlus)
 
 shinyApp(
   ui = dashboardPage(
     header = dashboardHeader(),
     sidebar = dashboardSidebar(),
     body = dashboardBody(),
     controlbar = dashboardControlbar(
      id = "controlbar",
      controlbarMenu(
       id = "menu",
       controlbarItem(
        "Tab 1",
        "Welcome to tab 1"
       ),
       controlbarItem(
        "Tab 2",
        "Welcome to tab 2"
       )
      )
     )
   ),
   server = function(input, output, session) {
     
     observeEvent(input$menu, {
       showModal(modalDialog(
         title = "Alert",
         sprintf(" \%s is active", input$menu),
         easyClose = TRUE,
         footer = NULL
       ))
     })
   }
 )
}

# Update a controlbar menu
if (interactive()) {
 library(shiny)
 library(shinydashboard)
 library(shinydashboardPlus)
 
 shinyApp(
   ui = dashboardPage(
     header = dashboardHeader(),
     sidebar = dashboardSidebar(),
     body = dashboardBody(
      radioButtons("controller", "Controller", choices = c(1, 2, 3))
     ),
     controlbar = dashboardControlbar(
      id = "controlbar",
      controlbarMenu(
       id = "menu",
       controlbarItem(
         paste0("Tab", 1),
         paste("Welcome to tab", 1)
       ),
       controlbarItem(
         paste0("Tab", 2),
         paste("Welcome to tab", 2)
       ),
       controlbarItem(
         paste0("Tab", 3),
         paste("Welcome to tab", 3)
       )
      )
     )
   ),
   server = function(input, output, session) {
    observeEvent(input$controller, {
     updateControlbarMenu(
      "menu", 
      selected = paste0("Tab", input$controller)
     )
    })
   }
 )
}
}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
