% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approach_ctree.R
\name{sample_ctree}
\alias{sample_ctree}
\title{Sample ctree variables from a given conditional inference tree}
\usage{
sample_ctree(tree, n_MC_samples, x_explain, x_train, n_features, sample)
}
\arguments{
\item{tree}{List. Contains tree which is an object of type ctree built from the party package.
Also contains given_ind, the features to condition upon.}

\item{n_MC_samples}{Scalar integer.
Corresponds to the number of samples from the leaf node.
See an exception when sample = FALSE in \code{\link[=setup_approach.ctree]{setup_approach.ctree()}}.}

\item{x_explain}{Data.table with the features of the observation whose
predictions ought to be explained (test data).}

\item{x_train}{Data.table with training data.}

\item{n_features}{Positive integer.
The number of features.}
}
\value{
data.table with \code{n_MC_samples} (conditional) Gaussian samples
}
\description{
Sample ctree variables from a given conditional inference tree
}
\details{
See the documentation of the \code{\link[=setup_approach.ctree]{setup_approach.ctree()}} function for undocumented parameters.
}
\author{
Annabelle Redelmeier
}
\keyword{internal}
