% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{dgamma_rvec}
\alias{dgamma_rvec}
\alias{pgamma_rvec}
\alias{qgamma_rvec}
\alias{rgamma_rvec}
\title{Gamma Distribution, Using Multiple Draws}
\usage{
dgamma_rvec(x, shape, rate = 1, scale = 1/rate, log = FALSE)

pgamma_rvec(
  q,
  shape,
  rate = 1,
  scale = 1/rate,
  lower.tail = TRUE,
  log.p = FALSE
)

qgamma_rvec(
  p,
  shape,
  rate = 1,
  scale = 1/rate,
  lower.tail = TRUE,
  log.p = FALSE
)

rgamma_rvec(n, shape, rate = 1, scale = 1/rate, n_draw = NULL)
}
\arguments{
\item{x}{Quantiles. Can be an rvec.}

\item{shape}{Shape parameter.
See \code{\link[=dgamma]{dgamma()}}. Can be an rvec.}

\item{rate}{Rate parameter. See \code{\link[stats:GammaDist]{stats::dgamma()}}.
Can be an rvec.}

\item{scale}{Scale parameter.
An alterative to \code{rate}. See \code{\link[=dgamma]{dgamma()}}.
Can be an rvec.}

\item{log, log.p}{Whether to return results
on a log scale. Default is
\code{FALSE}. Cannot be an rvec.}

\item{q}{Quantiles. Can be an rvec.}

\item{lower.tail}{Whether to return
\eqn{P[X \le x]}, as opposed to
\eqn{P[X > x]}. Default is \code{TRUE}.
Cannot be an rvec.}

\item{p}{Probabilities. Can be an rvec.}

\item{n}{The length of random vector being
created. Cannot be an rvec.}

\item{n_draw}{Number of random draws
in the random vector being
created. Cannot be an rvec.}
}
\value{
\itemize{
\item If any of the arguments are rvecs,
or if a value for \code{n_draw} is supplied,
then an \link[=rvec]{rvec}; otherwise an ordinary R vector.
}
}
\description{
Density, distribution function,
quantile function and random generation for the
gamma distribution, modified to work with
rvecs.
}
\details{
Functions \code{dgamma_rvec()}, \code{pgamma_rvec()},
\code{pgamma_rvec()} and \code{rgamma_rvec()} work like
base R functions \code{\link[=dgamma]{dgamma()}}, \code{\link[=pgamma]{pgamma()}},
\code{\link[=qgamma]{qgamma()}}, and \code{\link[=rgamma]{rgamma()}}, except that
they accept rvecs as inputs. If any
input is an rvec, then the output will be too.
Function \code{rgamma_rvec()} also returns an
rvec if a value for \code{n_draw} is supplied.

\code{dgamma_rvec()}, \code{pgamma_rvec()},
\code{pgamma_rvec()} and \code{rgamma_rvec()}
use \link[vctrs:theory-faq-recycling]{tidyverse}
vector recycling rules:
\itemize{
\item Vectors of length 1 are recycled
\item All other vectors must have the same size
}
}
\examples{
x <- rvec(list(c(3, 5.1),
               c(0.1, 2.3)))
dgamma_rvec(x, shape = 1)
pgamma_rvec(x, shape = 1)

rgamma_rvec(n = 2,
            shape = 1,
            rate = c(0.5, 1),
            n_draw = 1000)
}
\seealso{
\itemize{
\item \code{\link[=dgamma]{dgamma()}}, \code{\link[=pgamma]{pgamma()}}, \code{\link[=qgamma]{qgamma()}}, \code{\link[=rgamma]{rgamma()}} Base R equivalents
\item \link[stats:Distributions]{distributions} All base R distributions
}
}
