% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{wrap_model_to_juliaBUGS}
\alias{wrap_model_to_juliaBUGS}
\title{Wrap Bayesian Updating for Gibbs Sampling (BUGS) Model for Julia}
\usage{
wrap_model_to_juliaBUGS(model_code)
}
\arguments{
\item{model_code}{A character string containing the body of a Bayesian Updating for Gibbs Sampling (BUGS) model.
If the model already starts with `model = @bugs begin` and ends with `end`,
the function returns it unchanged.}
}
\value{
A character string with the BUGS model wrapped properly in Julia-compatible syntax.
}
\description{
Wraps a Bayesian Updating for Gibbs Sampling (BUGS) model string with `model = @bugs begin` and `end`,
if it is not already wrapped. This is useful for preparing BUGS models
for use with Julia packages that expect this specific block structure.
}
\examples{
\dontrun{
model_body <- "
  for i in 1:N
    r[i] ~ dbin(p[i], n[i])
    b[i] ~ dnorm(0.0, tau)
    p[i] = logistic(alpha0 + alpha1 * x1[i] + alpha2 * x2[i] + alpha12 * x1[i] * x2[i] + b[i])
  end
  alpha0 ~ dnorm(0.0, 1.0E-6)
  tau ~ dgamma(0.001, 0.001)
  sigma = 1 / sqrt(tau)
"
wrap_model_to_juliaBUGS(model_body)
}

}
