% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dummy.R
\name{dummy}
\alias{dummy}
\title{Create Dummy Variables}
\usage{
dummy(
  x,
  subset = rep(TRUE, length(x)),
  reference = sort(unique(x[!is.na(x)])),
  includeAll = FALSE
)
}
\arguments{
\item{x}{\code{y} variable used to create the dummy
variables.}

\item{subset}{\code{cluster} a subset of the data, if
desired.}

\item{reference}{the reference value for the dummy variables to compare to.}

\item{includeAll}{logical value indicating whether all of the dummy
variables should be returned (including the reference).}
}
\value{
A matrix containing the dummy
variables.
}
\description{
Creates dummy variables using a reference value.
}
\examples{

data(mri)

# Create a dummy variable for chd
dummy(mri$chd)

}
