% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova.R
\name{anova.uRegress}
\alias{anova.uRegress}
\title{ANOVA}
\usage{
\method{anova}{uRegress}(object, full_object, test = "LRT", robustSE = TRUE, useFdstn = TRUE, ...)
}
\arguments{
\item{object}{an object of class \code{uRegress}, the model with fewer parameters (i.e. the null model).}

\item{full_object}{an object of class \code{uRegress}, the model with more parameters (i.e. the full model).}

\item{test}{a character string specifying the test statistic to be used. Can be one of \code{'Wald'} or \code{'LRT'}, which 
corresponds to Wald or likelihood (partial likelihood for hazard regressions) ratio tests. Note that currently 
the Wald test is only supported for symbolically nested models; that is, when the larger model contains all 
the covariates (with the same names) in the smaller model.}

\item{robustSE}{a logical value indicating whether or not to use robust 
standard errors in calculation. Defaults to \code{TRUE}. 
If \code{TRUE}, then \code{robustSE} must
have been \code{TRUE} when \code{reg} was created.}

\item{useFdstn}{a logical indicator that the F distribution should be used for test statistics 
instead of the chi squared distribution. Defaults to \code{FALSE}. This option is not supported when 
input \code{reg} is a hazard regression (i.e., \code{fnctl="hazard"}).}

\item{...}{argument to be passed in}
}
\value{
A list of class \code{anova.uRegress} with the following components:
\describe{
 \item{printMat}{A formatted table with inferential results (i.e., test statistics and p-values) for comparing two nested models.}
 \item{null_model}{The null model in the comparison.}
 \item{full_model}{The full model in the comparison.}
}
}
\description{
Compute analysis of variance (or deviance) tables for two fitted, nested \code{uRegress} objects. The model with more parameters is referred to as the full model (or the larger model), and the model with fewer parameters is referred to as the null model (or the smaller model).
}
\examples{
# Loading required libraries
library(sandwich)

# Reading in a dataset
data(mri)

# Linear regression of LDL on age and stroke (with robust SE by default)
testReg_null <- regress ("mean", ldl~age+stroke, data = mri)

# Linear regression of LDL on age, stroke, and race (with robust SE by default)
testReg_full <- regress ("mean", ldl~age+stroke+race, data = mri)
# Comparing the two models using the Wald test with robust SE
anova(testReg_null, testReg_full, test = "Wald")
}
