% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/population.R
\name{ols_with_error}
\alias{ols_with_error}
\title{Family representing a linear relationship with non-Gaussian errors}
\usage{
ols_with_error(error, ...)
}
\arguments{
\item{error}{Function that can draw random variables from the non-Gaussian
distribution, or a string giving the name of the function. For example,
\code{rt} draws \emph{t}-distributed random variates. The function must take an
argument \code{n} indicating how many random variates to draw (as all random
generation functions built into R do).}

\item{...}{Further arguments passed to the \code{error} function to draw random
variates, such as to specify degrees of freedom, shape parameters, or other
parameters of the distribution. These arguments are evaluated with the
model data in the environment, so they can be expressions referring to
model data, such as values of the predictors.}
}
\value{
A family object representing this family.
}
\description{
The \code{ols_with_error()} family can represent any non-Gaussian error, provided
random variates can be drawn by an R function. A family specified this way
can be used to specify a population (via \code{population()}), but can't be used
to estimate a model (such as with \code{glm()}).
}
\examples{
# t-distributed errors with 3 degrees of freedom
ols_with_error(rt, df = 3)

# A linear regression with t-distributed error, using error_scale to make
# errors large
population(
  x1 = predictor(rnorm, mean = 4, sd = 10),
  x2 = predictor(runif, min = 0, max = 10),
  y = response(0.7 + 2.2 * x1 - 0.2 * x2,
               family = ols_with_error(rt, df = 4),
               error_scale = 2.5)
)

# Cauchy-distributed errors
ols_with_error(rcauchy, scale = 3)

# A contaminated error distribution, where
# 95\% of observations are Gaussian and 5\% are Cauchy
rcontaminated <- function(n) {
  contaminant <- rbinom(n, 1, prob = 0.05)

  return(ifelse(contaminant == 1,
                rcauchy(n, scale = 20),
                rnorm(n, sd = 1)))
}
ols_with_error(rcontaminated)
}
\seealso{
\code{\link[=custom_family]{custom_family()}} for fully custom families, including for GLMs
}
