% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refdb_export.R
\name{refdb_export_dada2}
\alias{refdb_export_dada2}
\title{Export reference database for DADA2}
\usage{
refdb_export_dada2(x, file, mode = "taxonomy")
}
\arguments{
\item{x}{a reference database.}

\item{file}{a path to the file to be written.}

\item{mode}{character string to determine the type of file to produce.
Use \code{"taxonomy"} to produce a file for function \code{assignTaxonomy}
or \code{"species"} to produce a file for function \code{assignSpecies}.}
}
\value{
No return value, called for side effects.
}
\description{
Write reference database in formats which can be used with the
functions of the package \pkg{dada2}.
}
\examples{
lib <- read.csv(system.file("extdata", "baetidae_bold.csv", package = "refdb"))
lib <- refdb_set_fields_BOLD(lib)
refdb_export_dada2(lib, tempfile())

}
