% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{make.dummy}
\alias{make.dummy}
\title{Make Dummy Columns}
\usage{
make.dummy(..., rtn.lgl = FALSE)
}
\arguments{
\item{...}{logical conditions that evaluate to logical vectors of the same
length. If the logical vectors are not the same length, an error is
returned. The names of the arguments are the colnames in the return object.
If unnamed, then default R data.frame naming is used, which can get ugly.}

\item{rtn.lgl}{logical vector of length 1 specifying whether the dummy
columns should be logical vectors (TRUE) rather than numeric vectors
(FALSE).}
}
\value{
data.frame of dummy columns based on the logical conditions n
  \code{...}. If \code{rtn.lgl} = TRUE, then the columns are logical vectors.
  If \code{out.lgl} = FALSE, then the columns are numeric vectors where 0 =
  FALSE and 1 = TRUE. The colnames are the names of the arguments in
  \code{...}. If not specified, then default data.frame names are created
  from the logical conditions themselves (which can get ugly).
}
\description{
\code{make.dummy} creates dummy columns (i.e., dichotomous numeric vectors
coded 0 and 1) from logical conditions. If you want to make logical
conditions from columns of a data.frame, you will need to call the data.frame
and its columns explicitly as this function does not use non-standard
evaluation.
}
\examples{
make.dummy(attitude$"rating" > 50) # ugly colnames
make.dummy("rating_50plus" = attitude$"rating" > 50,
   "advance_50minus" = attitude$"advance" < 50)
make.dummy("rating_50plus" = attitude$"rating" > 50,
   "advance_50minus" = attitude$"advance" < 50, rtn.lgl = TRUE)
\dontrun{
   make.dummy("rating_50plus" = attitude$"rating" > 50,
      "mpg_20plus" = mtcars$"mpg" > 20)
}
}
\seealso{
\code{\link{make.dumNA}}
}
