% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reshape_projoint.R
\name{reshape_projoint}
\alias{reshape_projoint}
\title{Reshape survey response data for conjoint analysis (single task set)}
\usage{
reshape_projoint(
  .dataframe,
  .outcomes,
  .choice_labels = c("A", "B"),
  .alphabet = "K",
  .idvar = "ResponseId",
  .repeated = TRUE,
  .flipped = TRUE,
  .covariates = NULL,
  .fill = FALSE
)
}
\arguments{
\item{.dataframe}{A data frame, preferably from \code{\link{read_Qualtrics}}.}

\item{.outcomes}{Character vector of outcome column names in the \emph{asked order}.
If a repeated task is used, its outcome must be the \emph{last element}.}

\item{.choice_labels}{Character vector (default \code{c("A","B")}) giving the two labels that
appear at the end of the outcome strings.}

\item{.alphabet}{Single character (default \code{"K"}) indicating the Qualtrics prefix.}

\item{.idvar}{Character (default \code{"ResponseId"}) indicating the respondent id column.}

\item{.repeated}{Logical (default \code{TRUE}) indicating whether a repeated task is present.}

\item{.flipped}{Logical (default \code{TRUE}) indicating whether the repeated task flips profiles
before agreement is computed.}

\item{.covariates}{Optional character vector of respondent-level covariate column names to carry through.}

\item{.fill}{Logical (default \code{FALSE}). If \code{TRUE}, fills \code{agree} within respondent
across tasks as described under “Filling agreement”.}
}
\value{
A \code{projoint_data} object with elements \code{$labels} and \code{$data}; see Details.
}
\description{
Takes a wide survey data frame (e.g., from \code{\link{read_Qualtrics}}) and reshapes
it so that each row corresponds to a single respondent–task–profile. Supports arbitrary
ordering of base tasks and a single repeated task per respondent. The repeated base task
is inferred from the first base outcome in \code{.outcomes}, and the repeated outcome
must be the last element of \code{.outcomes}.
}
\details{
\strong{Scope and assumptions}
\itemize{
  \item One set of conjoint tasks with exactly two profiles per task (profiles 1 and 2).
  \item For multi-set designs, call \code{reshape_projoint()} once per set and bind the results.
}

\strong{Expected input (Qualtrics K-codes)}
\itemize{
  \item Wide columns named \code{K-<task>-<attribute>} (attribute names) and
        \code{K-<task>-<profile>-<attribute>} (level names), with \code{<task>} in \code{1..n}
        and \code{<profile>} in \code{1,2}.
  \item Rows with missing \code{K-1-1} are dropped as empty tables (server hiccup safeguard).
}

\strong{Outcome columns (\code{.outcomes})}
\itemize{
  \item List all choice variables in the \emph{order asked}. If you include a repeated task,
        its outcome must be the \emph{last element}.
  \item For base tasks (all but the last element), the function extracts the base task id by
        reading the \emph{digits} in each outcome name (e.g., \code{"choice4"}, \code{"Q4"},
        \code{"task04"} -> task 4).
  \item The set of base task ids extracted from \code{.outcomes} must exactly match the set of
        task ids present in the K-codes; otherwise an error is thrown.
  \item The repeated base task is inferred as the digits in the \emph{first base outcome}
        (i.e., the first element of \code{.outcomes}, excluding the final repeated outcome).
}

\strong{Choice parsing}
\itemize{
  \item The selected profile is parsed from the \emph{last character} of each outcome string
        and matched to \code{.choice_labels}. Ensure outcomes end with these labels (e.g.,
        \code{"Candidate A"}/\code{"Candidate B"}). If outcomes are numeric or differently
        formatted, pre-process or adjust \code{.choice_labels} accordingly.
}

\strong{Output}
\itemize{
  \item A \code{projoint_data} object with:
    \itemize{
      \item \code{$labels}: map from human-readable \code{attribute}/\code{level} to stable ids
            (\code{attribute_id = "att1","att2",...}, \code{level_id = "attX:levelY"}).
      \item \code{$data}: tibble with one row per \code{id}–\code{task}–\code{profile}, attribute
            columns (named \code{att*}) storing \code{level_id}, \code{selected} (1 if that profile
            was chosen; 0 otherwise), \code{agree} (1/0/NA for repeated-task agreement after flip logic),
            and any \code{.covariates}. \code{id} is coerced to character; attribute columns are factors.
    }
}

\strong{Filling agreement}
\itemize{
  \item If \code{.fill = TRUE}, \code{agree} is filled within respondent across tasks in task order,
        propagating the observed repeated-task agreement to all tasks for that respondent. This assumes
        IRR is respondent-specific and independent of table content.
}

\strong{Diagnostics}
\itemize{
  \item \code{dplyr::count(reshaped$data, task, profile)} should show exactly two rows per task.
  \item If \code{pj_estimate()} later reports “No rows match the specified attribute/level”, construct QoIs
        from \code{reshaped$labels} (use the exact \code{attX:levelY} ids).
}
}
\examples{
\donttest{
# Base tasks asked in numeric order; repeated task corresponds to task 1
data(exampleData1)
outcomes <- c(paste0("choice", 1:8), "choice1_repeated_flipped")
reshaped <- reshape_projoint(exampleData1, outcomes)
dplyr::count(reshaped$data, task, profile)  # should be 2 per task
}

}
\seealso{
\code{\link{make_projoint_data}}, \code{\link{projoint}}
}
