% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqData_wrappers.R
\name{voom_wrapper}
\alias{voom_wrapper}
\title{Wrapper for limma-voom workflow}
\usage{
voom_wrapper(
  omicsData,
  p_adjust = "BH",
  comparisons = NULL,
  p_cutoff = 0.05,
  ...
)
}
\arguments{
\item{omicsData}{an object of type 'seqData', created by
\code{\link{as.seqData}}}

\item{p_adjust}{Character string for p-value correction method, refer to
?p.adjust() for valid options}

\item{comparisons}{`data.frame` with columns for "Control" and "Test"
containing the different comparisons of interest. Comparisons will be made
between the Test and the corresponding Control  If left NULL, then all
pairwise comparisons are executed.}

\item{p_cutoff}{Numeric value between 0 and 1 for setting p-value
significance threshold}

\item{...}{additional arguments passed to methods functions. Note, formatting
option changes will interfere with wrapping functionality.}
}
\value{
statRes object
}
\description{
For generating statistics for 'seqData' objects
}
\details{
Runs default limma-voom workflow using empirical Bayes moderated
  t-statistics. Additional arguments can be passed for use in the function,
  refer to calcNormFactors() in edgeR package.
}
\references{
Ritchie, M.E., Phipson, B., Wu, D., Hu, Y., Law, C.W., Shi, W., and Smyth,
 G.K. (2015). limma powers differential expression analyses for
 RNA-sequencing and microarray studies. Nucleic Acids Research 43(7), e47.
}
