% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_dataRes.R
\name{report_dataRes}
\alias{report_dataRes}
\title{Creates a data frame displaying multiple metrics}
\usage{
report_dataRes(dataRes, minmax = FALSE, digits = 2)
}
\arguments{
\item{dataRes}{an object of the class 'dataRes', created by
\code{\link{edata_summary}}.}

\item{minmax}{logical specifying whether or not to include minimum and
maximum data in the returned data frame. Defaults to FALSE.}

\item{digits}{integer indicating the number of decimal places to round}
}
\value{
prints a data frame
}
\description{
This function takes in an object of class 'dataRes' and returns a data frame
displaying a combination of metrics. The six summarizing metrics include,
mean, standard deviation, median, percent observed, minimum, and maximum.
}
\details{
When creating the 'dataRes' object via \code{\link{edata_summary}},
  if the 'by' argument is set to 'sample', then the 'groupvar' argument must
  be NULL
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE) && requireNamespace("knitr", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(pmartRdata)
mylipid <- edata_transform(omicsData = lipid_neg_object, data_scale = "log2")

dataRes_sample <- edata_summary(omicsData = mylipid, groupvar = NULL, by = "sample")
my_output <- report_dataRes(dataRes_sample)
\dontshow{\}) # examplesIf}
}
