% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/protein_quant.R
\name{protein_quant}
\alias{protein_quant}
\title{Protein Quantification}
\usage{
protein_quant(
  pepData,
  method,
  isoformRes = NULL,
  qrollup_thresh = NULL,
  single_pep = FALSE,
  single_observation = FALSE,
  combine_fn = "median",
  parallel = TRUE,
  emeta_cols = NULL,
  emeta_cols_sep = ";"
)
}
\arguments{
\item{pepData}{an omicsData object of the class 'pepData'}

\item{method}{character string specifying one of four protein quantification methods, 'rollup',
'rrollup', 'qrollup' and 'zrollup'}

\item{isoformRes}{list of data frames, the result of applying the
'bpquant' function to original pepData object. Defaults to NULL.}

\item{qrollup_thresh}{numeric value; is the peptide abundance cutoff
value. Is an argument to qrollup function.}

\item{single_pep}{logical indicating whether or not to remove proteins that
have just a single peptide mapping to them, defaults to FALSE.}

\item{single_observation}{logical indicating whether or not to remove
peptides that have just a single observation, defaults to FALSE.}

\item{combine_fn}{character string specifying either be 'mean', 'median', or 
'sum'. Using 'sum' is only supported when method is 'rollup'.}

\item{parallel}{logical indicating whether or not to use "doParallel"
loop in applying rollup functions. Defaults to TRUE. Is an argument of
rrollup, qrollup and zrollup functions.}

\item{emeta_cols}{character vector indicating additional columns of e_meta
that should be kept after rolling up to the protein level. The default,
NULL, only keeps the column containing the mapping variable along with the
new columns created (peps_per_pro and n_peps_used).}

\item{emeta_cols_sep}{character specifying the string that will separate the 
elements for emeta_cols when they are collapsed into a single row when aggregating
rows belonging to the same protein.  Defaults to ";"}
}
\value{
omicsData object of the class 'proData'
}
\description{
This function takes in a pepData object, method (quantification method, mean,
median or rrollup), and the optional argument isoformRes (defaults to NULL).
An object of the class 'proData' is returned.
}
\details{
If isoformRes is provided then, a temporary pepData object is formed
  using the isoformRes information as the e_meta component and the original
  pepData object will be used for e_data and f_data components. The
  emeta_cname for the temporary pepData object will be the 'protein_isoform'
  column of isoformRes. Then one of the three 'method' functions can be
  applied to the temporary pepData object to return a proData object. If
  isofromRes is left NULL, then depending on the input for 'method', the
  correct 'method' function is applied directly to the input pepData object
  and a proData object is returned.
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
library(pmartRdata)

mypepData <- group_designation(omicsData = pep_object, main_effects = c("Phenotype"))
mypepData = edata_transform(omicsData = mypepData, "log2")

imdanova_Filt <- imdanova_filter(omicsData = mypepData)
mypepData <- applyFilt(filter_object = imdanova_Filt, omicsData = mypepData, min_nonmiss_anova = 2)

imd_anova_res <- imd_anova(omicsData = mypepData, test_method = 'comb',
                           pval_adjust_a_multcomp = 'bon', pval_adjust_g_multcomp = 'bon')

isoformRes = bpquant(statRes = imd_anova_res, pepData = mypepData)

# case where isoformRes is NULL:
results <- protein_quant(pepData = mypepData, method = 'rollup',
                         combine_fn = 'median', isoformRes = NULL)

# case where isoformRes is provided:
# results2 = protein_quant(pepData = mypepData, method = 'rollup',
#                           combine_fn = 'mean', isoformRes = isoformRes)
}
\dontshow{\}) # examplesIf}
}
\references{
Webb-Robertson, B.-J. M., Matzke, M. M., Datta, S., Payne, S. H.,
  Kang, J., Bramer, L. M., ... Waters, K. M. (2014). \emph{Bayesian
  Proteoform Modeling Improves Protein Quantification of Global Proteomic
  Measurements}. Molecular & Cellular Proteomics.: MCP, 13(12), 3639-3646.
}
