% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_funcs.R
\name{ppp}
\alias{ppp}
\title{Identify Biomolecules from the Proportion Present (PPP) for Use in
Normalization}
\usage{
ppp(e_data, edata_id, proportion = 0.5)
}
\arguments{
\item{e_data}{a \eqn{p \times n + 1} data.frame, where \eqn{p} is the number
of peptides, proteins, lipids, or metabolites and \eqn{n} is the number of
samples. Each row corresponds to data for a peptide, protein, lipid, or
metabolite, with one column giving the biomolecule identifier name.}

\item{edata_id}{character string indicating the name of the peptide, protein,
lipid, or metabolite identifier. Usually obtained by calling
\code{attr(omicsData, "cnames")$edata_cname}.}

\item{proportion}{numeric value between 0 and 1, indicating the proportion at
or above which a biomolecule must be present across all samples in order to be
retained (default value 0.5)}
}
\value{
Character vector containing the biomolecules belonging to the PPP
  subset.
}
\description{
Selects biomolecules for normalization via the method of percentage of the
peptides (or proteins, metabolites, etc.) present (PPP)
}
\details{
Biomolecules present across \code{proportion} samples are designated as
  PPP.
}
\author{
Kelly Stratton
}
