% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_objects.R
\name{molecule_filter}
\alias{molecule_filter}
\title{Molecule Filter Object}
\usage{
molecule_filter(omicsData, use_groups = FALSE, use_batch = FALSE)
}
\arguments{
\item{omicsData}{object of the class 'pepData', 'proData', 'metabData',
'lipidData', 'nmrData', or 'seqData', created by \code{\link{as.pepData}},
\code{\link{as.proData}}, \code{\link{as.metabData}},
\code{\link{as.lipidData}}, \code{\link{as.nmrData}}, or \code{\link{as.seqData}}, respectively.}

\item{use_groups}{logical indicator for whether to utilize group information
from \code{\link{group_designation}} when calculating the molecule filter.
Defaults to FALSE. When group information is used to calculate the molecule
filter, the minimum number of observations is required within each group,
as opposed to across all samples regardless of group membership.}

\item{use_batch}{logical indicator for whether to utilize batch information
from \code{\link{group_designation}} when calculating the molecule filter.
Defaults to FALSE. When batch information is used to calculate the molecule
filter, the minimum number of observations is required within each batch,
as opposed to across all samples regardless of batch. If ComBat or similar
method will be used for downstream batch effect correction, this argument
should be set to TRUE.}
}
\value{
An S3 object of class 'moleculeFilt' (also a data.frame) that contains the
  molecule identifier and the number of samples for which the molecule was
  observed (i.e. not NA)
}
\description{
This function returns a moleculeFilt object for use with
\code{\link{applyFilt}}
}
\details{
Attribute of molecule_filt object is "total_poss_obs", the number of
  total possible observations for each feature (same as the number of
  samples)
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(pmartRdata)
to_filter <- molecule_filter(omicsData = pep_object)
summary(to_filter, min_num = 2)
\dontshow{\}) # examplesIf}
}
\author{
Kelly Stratton
}
