% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.trelliData.R
\name{as.trelliData.edata}
\alias{as.trelliData.edata}
\title{Generate an object from edata to pass to trelliscope building
  functions}
\usage{
as.trelliData.edata(
  e_data,
  edata_cname,
  omics_type,
  data_scale_original = "abundance",
  data_scale = "log2",
  normalization_fun = "global",
  normalization_params = list(subset_fn = "all", norm_fn = "median", apply_norm = TRUE,
    backtransform = TRUE),
  is_normalized = FALSE,
  force_normalization = FALSE
)
}
\arguments{
\item{e_data}{a \eqn{p * (n + 1)} data.frame of expression data, where
\eqn{p} is the number of biomolecules observed and \eqn{n} is the number of
samples (an additional biomolecule identifier/name column should also be
present anywhere in the data.frame). Each row corresponds to data for one
biomolecule. One column specifying a unique identifier for each biomolecule
(row) must be present. We do not recommend passing data that requires
reference normalization (isobaric, nmr, etc.)}

\item{edata_cname}{character string specifying the name of the column
containing the biomolecule identifiers. It should be the only non-numeric
colummn in edata.}

\item{omics_type}{A string specifying the data type. Acceptable options are
"pepData", "isobaricpepData", "proData", "metabData", "lipidData", 
"nmrData", or "seqData".}

\item{data_scale_original}{A character string indicating original scale
of the data. Valid values are: 'log2', 'log', 'log10', or 'abundance'.
Default is abundance. This parameter is ignored if the data is "seqData".}

\item{data_scale}{A character string indicating the scale to transform the
data to. Valid values are: 'log2', 'log', 'log10', or 'abundance'. If the
value is the same as data_scale_original, then transformation is not
applied. Default is log2. This parameter is ignored if the data is "seqData".}

\item{normalization_fun}{A character string indicating the pmartR
normalization function to use on the data, if is_normalized is FALSE.
Acceptable choices are 'global', 'loess', and 'quantile'. This parameter is
ignored if the data is "seqData".}

\item{normalization_params}{A vector or list where the normalization
parameters are the names, and the parameter values are the list values. For
example, an acceptable entry for 'normalize_global' would be
list("subset_fn" = "all", "norm_fn" = "median", "apply_norm" = TRUE,
"backtransform" = TRUE). This parameter is ignored if the data is "seqData".}

\item{is_normalized}{A logical indicator of whether the data is already
normalized (and will therefore skip the normalization step). This parameter is
ignored if the data is "seqData".}

\item{force_normalization}{A logical indicator to force normalization that is
not required for both isobaric protein and NMR data. This parameter is ignored
if the data is "seqData."}
}
\value{
An object of class 'trelliData' containing the raw data.
 To be passed to trelliscope building functions.
}
\description{
The only acceptable input file type is a single edata file.
  Transformation and normalization must be specified. Isobaric protein or NMR
  data does not need to be normalized.
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(pmartRdata)

###########################
## MS/NMR OMICS EXAMPLES ##
###########################

# Simple MS/NMR Example 
trelliData1 <- as.trelliData.edata(e_data = pep_edata,
                                   edata_cname = "Peptide",
                                   omics_type = "pepData")
 
######################
## RNA-SEQ EXAMPLES ##  
######################
                                    
# RNA-seq Example
trelliData_seq1 <- as.trelliData.edata(e_data = rnaseq_edata, 
                                      edata_cname = "Transcript",
                                      omics_type = "seqData")
                                  
          
\dontshow{\}) # examplesIf}
}
\author{
David Degnan, Daniel Claborne, Lisa Bramer
}
