% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/condense_control.R
\name{condense_control}
\alias{condense_control}
\title{Condense control object into strictly smaller control object}
\usage{
condense_control(x, ref, ..., call = rlang::caller_env())
}
\arguments{
\item{x}{A control object to be condensed.}

\item{ref}{A control object that is used to determine what element should be
kept.}

\item{call}{The execution environment of a currently running function, e.g.
\code{caller_env()}. The function will be mentioned in error messages as the
source of the error. See the call argument of \code{\link[rlang:abort]{rlang::abort()}} for more
information.}
}
\value{
A control object with the same elements and classes of \code{ref}, with
values of \code{x}.
}
\description{
This function is used to help the hierarchy of control functions used
throughout the tidymodels packages. It is now assumed that each control
function is either a subset or a superset of another control function.
}
\examples{
\dontshow{if (!parsnip:::is_cran_check()) withAutoprint(\{ # examplesIf}
ctrl <- control_parsnip(catch = TRUE)
ctrl$allow_par <- TRUE
str(ctrl)

ctrl <- condense_control(ctrl, control_parsnip())
str(ctrl)
\dontshow{\}) # examplesIf}
}
\keyword{internal}
