% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateSparsity.R
\name{calculateSparsity}
\alias{calculateSparsity}
\title{Calculate sparsity across the feature mode of a multi-way array.}
\usage{
calculateSparsity(dataset, considerGroups = FALSE, groupVariable = "")
}
\arguments{
\item{dataset}{See \link{Fujita2023}, \link{Shao2019} or \link{vanderPloeg2024}.}

\item{considerGroups}{Consider subject groups in calculating sparsity (default FALSE)}

\item{groupVariable}{Column name in dataset$mode1 that should be used to consider groups (default "")}
}
\value{
Vector of sparsity fractions (N x J) where N is the number of groups and J is the number of features.
}
\description{
Calculate sparsity across the feature mode of a multi-way array.
}
\examples{
# No groups
sparsity = calculateSparsity(Fujita2023)
length(sparsity)
hist(sparsity)

# Consider groups
colnames(Shao2019$mode1)
sparsity = calculateSparsity(Shao2019, considerGroups=TRUE, groupVariable="Delivery_mode")
dim(sparsity)
hist(sparsity[1,])
hist(sparsity[2,])

}
