% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pbdb_queries.R
\name{pbdb_occurrences}
\alias{pbdb_occurrences}
\title{Get information about fossil occurrence records}
\usage{
pbdb_occurrences(...)
}
\arguments{
\item{...}{Arguments passed to the API. See all available arguments at
\url{https://paleobiodb.org/data1.2/occs/list}.
\itemize{
\item \code{limit}: Limits the number of records returned. The value may be
a positive integer, zero, or \code{"all"}.
\item \code{taxon_name}: Return only records associated with the specified
taxonomic name(s).  You may specify multiple names.
\item \code{base_name}: Return records associated with the specified
taxonomic name(s) and any of their children (e.g. \code{base_name = "Canis"} will return "Canis", "Canis lupus",
"Canis mosbachensis", etc.)
\item \code{lngmin}: Numeric. The longitude boundaries will be normalized to
fall between -180 and 180. Note that if you specify \code{lngmin} then
you must also specify \code{lngmax}.  Returns only records whose
geographic location falls within the given bounding box (defined
by \code{lngmin}, \code{lngmax}, \code{latmin}, \code{latmax}).  It generates two
adjacent bounding boxes if the range crosses the antimeridian.
\item \code{lngmax}: Numeric. The longitude boundaries will be normalized to
fall between -180 and 180.
\item \code{latmin}: Numeric value between -90 and 90.  Note that if you
specify \code{latmin} then you must also specify \code{latmax}.
\item \code{latmax}: Numeric value between -90 and 90.
\item \code{min_ma}: Return only records whose temporal locality is at least
this old, specified in millions of years.
\item \code{max_ma}: Return only records whose temporal locality is at most
this old, specified in millions of years.
\item \code{interval}: Return only records whose temporal locality falls
within the named geologic time interval (e.g. "Miocene").
\item \code{cc}: Return only records whose location falls within the
specified geographic regions. The value of this parameter should
be one or more two-character country codes and/or three-character
continent codes as a comma-separated list (see
\url{https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2} and
\url{https://paleobiodb.org/data1.2/config.txt?show=continents}). If
the parameter value starts with !, then records falling into
these regions are excluded instead of included. Any country codes
starting with ^ are subtracted from the filter.
\item \code{show}: Show extra variables (e.g. \code{"coords"}, \code{"classext"},
\code{"ident"}).
}}
}
\value{
A data frame with the fossil occurrences.
}
\description{
Returns information about fossil occurrence records stored in the
Paleobiology Database.
}
\details{
Documentation for all the parameters is available at
\url{https://paleobiodb.org/data1.2/occs/list}. We describe the
most common filters that paleontologists and ecologists might use
in the parameter list above.

Be aware that depending on the query, some columns may not be
returned by the API if those are empty across all the rows.
}
\examples{
\dontrun{
  pbdb_occurrences(id = c(10, 11), show = c("coords", "classext", "ident"))
  pbdb_occurrences(
    limit = "all", vocab = "pbdb", taxon_name = "Canis",
    show = c("coords", "classext", "ident")
  )
  pbdb_occurrences(
    limit = "all", vocab = "pbdb", base_name = "Canidae",
    show = c("coords", "classext", "ident")
  )
}
}
