% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example.R
\name{orderly_example}
\alias{orderly_example}
\title{Copy a simple orderly example}
\usage{
orderly_example(..., names = NULL, example = "demo", dest = NULL)
}
\arguments{
\item{...}{Arguments passed through to \code{\link[=orderly_init]{orderly_init()}}}

\item{names}{Optionally, names of the reports to copy.  The
default is to copy all reports.}

\item{example}{The name of the example to copy. Currently only
"simple" and "demo" are supported.}

\item{dest}{The destination. By default we use
\code{withr::local_tempdir()} which will create a temporary directory
that will clean itself up. This is suitable for use from the
orderly examples, but you may prefer to provide your own path,
in which case the path must not already exist.}
}
\value{
Invisibly, the path to the example.
}
\description{
Copy a simple orderly example for use in the docs. This function
should not form part of your workflow!
}
\examples{
path <- orderly_example()
orderly_list_src(root = path)
}
