% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{no_config}
\alias{no_config}
\title{Create empty property configuration}
\usage{
no_config()
}
\value{
An empty \verb{named list} that serialises to \code{{}} in JSON
}
\description{
Helper function that creates an empty named list for property configurations
that require no additional settings.

Many \href{https://developers.notion.com/reference/property-object}{database properties} like text, checkbox and date
do not need configuration settings.
This function returns the empty configuration (\code{{}} in JSON)
that these properties expect.
}
\examples{
\dontshow{if (notion_token_exists()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
notion <- notion_client()

# ----- create a database
\dontshow{notionapi::vcr_example_start("notion-databases-create")}
notion$databases$create(
  parent = list(page_id = "23933ea0-c1e4-81d6-a6f6-dd5b57ad4aba"),
  title = list(
    list(
      type = "text",
      text = list(
        content = "Grocery list"
      )
    )
  ),
  properties = list(
    Name = list(
      title = no_config()
    ),
    `In stock` = list(
      checkbox = no_config()
    )
  )
)
\dontshow{notionapi::vcr_example_end()}
\dontshow{\}) # examplesIf}
}
