% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_geoconnex.R
\name{get_geoconnex_reference}
\alias{get_geoconnex_reference}
\title{get geoconnex reference feature layers}
\usage{
get_geoconnex_reference(
  AOI,
  type = NULL,
  t_srs = NULL,
  buffer = 0.5,
  status = TRUE
)
}
\arguments{
\item{AOI}{bbox, sf polygon or point, or a URL that will return an sf object when passed to
\link[sf]{read_sf}}

\item{type}{character the feature type chosen from \link{discover_geoconnex_reference}}

\item{t_srs}{character (PROJ string or EPSG code) or numeric (EPSG code).
A user specified - target -Spatial Reference System (SRS/CRS) for returned objects.
Will default to the CRS of the input AOI if provided, and to 4326 for ID requests.}

\item{buffer}{numeric. The amount (in meters) to buffer a POINT AOI by for an
extended search. Default = 0.5}

\item{status}{boolean print status or not}
}
\value{
sf data.frame containing requested reference features
}
\description{
Queries the geoconnex reference feature server for features of interest.
}
\examples{
\donttest{

dplyr::distinct(discover_geoconnex_reference()[c("id", "title")])

AOI <- sf::st_as_sfc(sf::st_bbox(c(xmin = -89.56684, ymin = 42.99816,
                                   xmax = -89.24681, ymax = 43.17192),
                                 crs = "+proj=longlat +datum=WGS84 +no_defs"))

get_geoconnex_reference(AOI, type = "hu04")

get_geoconnex_reference("https://geoconnex.us/ref/mainstems/315626", type = "hu04", )

AOI <- sf::st_sfc(sf::st_point(c(-89.56684, 42.99816)),
                  crs = "+proj=longlat +datum=WGS84 +no_defs")

get_geoconnex_reference(AOI, type = "hu04", buffer = 100000)

}
}
