% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regtemplate.R
\name{all_templatebrains}
\alias{all_templatebrains}
\alias{guess_templatebrain}
\title{Find all template brains or those matching a given image volume}
\usage{
all_templatebrains(cached = TRUE, remove.duplicates = FALSE)

guess_templatebrain(
  x,
  rval = c("templatebrain", "name"),
  cached = TRUE,
  mustWork = FALSE
)
}
\arguments{
\item{cached}{When \code{TRUE} returns precomputed (memoised) results,
otherwise rescans searching for all template brains.}

\item{remove.duplicates}{Whether to remove duplicate template brains (as
determined by md5 hash) from the result list}

\item{x}{A \code{\link[nat]{im3d}} image object, array or matrix compatible
with \code{\link{as.templatebrain}} OR a 2 or 3-vector defining the
dimensions of an image or image stack.}

\item{rval}{Whether to return the \code{\link{templatebrain}} object itself
or just its name.}

\item{mustWork}{Whether to insist that exactly one template brain is found}
}
\value{
For \code{all_templatebrains}, a \code{data.frame} containing the
  following columns: \itemize{

  \item object The name of the \code{templatebrain} object

  \item pos An integer specifying the environment

  \item package Character vector naming the environment

  \item md5 md5 hash of the \code{templatebrain} object

  \item name

  \item W,H,D Width, height and depth of image stack (pixels)

  }

\code{guess_templatebrain} returns a \code{\link{templatebrain}}
  object when \code{rval='templatebrain'} or a character vector when
  \code{rval='name'}.
}
\description{
\code{all_templatebrains} returns a data.frame detailing all
  \code{templatebrain} objects on the search path (including those inside
  packages).
}
\examples{
\dontrun{
all_templatebrains()

guess_templatebrain(im3d(dims=c(30,40,50)))
# or
guess_templatebrain(c(30,40,50))
guess_templatebrain('path/to/my/image.nrrd')

if(require('nat.flybrains')){
  guess_templatebrain(im3d(dims=c(1024,512,218)), rval = 'name')
  # get the matching template brain
  tb=guess_templatebrain(im3d(dims=c(1024,512,218)))
  # get its voxel dimensions
  voxdims(tb)

  tb=guess_templatebrain(c(1024,512))
  tb
}
}
}
\seealso{
\code{\link{templatebrain}}
}
