% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MDmiss.R
\name{MDmiss}
\alias{MDmiss}
\title{Mahalanobis distance (MD) for data with missing values}
\usage{
MDmiss(data, center, cov)
}
\arguments{
\item{data}{the data as a dataframe or matrix.}

\item{center}{the center to be used (may not contain missing values).}

\item{cov}{the covariance to be used (may not contain missing values).}
}
\value{
The function returns a vector of the (squared) Mahalanobis distances.
}
\description{
For each observation the missing dimensions are omitted
before calculating the MD. The MD contains a correction
factor \eqn{p/q} to account for the number of observed values,
where \eqn{p} is the number of variables and \eqn{q} is the number of
observed dimensions for the particular observation.
}
\details{
The function loops over the observations. This is not optimal if
only a few missingness patterns occur. If no missing values occur
the function returns the Mahalanobis distance.
}
\examples{
data(bushfirem, bushfire)
MDmiss(bushfirem, apply(bushfire, 2, mean), var(bushfire))
}
\references{
Béguin, C., and Hulliger, B. (2004). Multivariate outlier detection
in incomplete survey data: The epidemic algorithm and transformed rank correlations.
Journal of the Royal Statistical Society, A167 (Part 2.), pp. 275-294.
}
\seealso{
\link[stats]{mahalanobis}
}
\author{
Beat Hulliger
}
