% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmcmcBayes.R
\name{mmcmcBayes}
\alias{mmcmcBayes}
\title{Multi-stage MCMC Bayesian Method for DMR Detection}
\usage{
mmcmcBayes(
  cancer_data,
  normal_data,
  stage = 1,
  max_stages = 3,
  num_splits = 10,
  test = "BF",
  mcmc = NULL,
  priors_cancer = NULL,
  priors_normal = NULL,
  bf_thresholds = NULL,
  pvalue_thresholds = NULL,
  return_mcmc = FALSE
)
}
\arguments{
\item{cancer_data}{A matrix of methylation data for the cancer group (rows: regions, columns: samples)}

\item{normal_data}{A matrix of methylation data for the normal group (rows: regions, columns: samples)}

\item{stage}{The starting stage for multi-stage analysis (default: 1)}

\item{max_stages}{Maximum number of stages (default: 3)}

\item{num_splits}{Number of splits for the data in each stage (default: 10)}

\item{test}{Type of test to use: "BF" for Bayes Factor, "pvalue" for p-value (default: "BF")}

\item{mcmc}{A list of MCMC parameters (default: NULL, uses function defaults)}

\item{priors_cancer}{Prior parameters for the cancer group (default: NULL, uses function defaults)}

\item{priors_normal}{Prior parameters for the normal group (default: NULL, uses function defaults)}

\item{bf_thresholds}{Bayes Factor thresholds for each stage (default: NULL, uses function defaults)}

\item{pvalue_thresholds}{p-value thresholds for each stage (default: NULL, uses function defaults)}

\item{return_mcmc}{Logical indicating whether to return MCMC samples for diagnostic purposes (default: FALSE)}
}
\value{
A list containing DMR detection results and, if requested, MCMC samples.

Returns NULL if no significant DMRs are detected.
}
\description{
This function implements a multi-stage MCMC Bayesian method for detecting differentially methylated regions (DMRs)
between cancer and normal groups. It uses the ASGN model for parameter estimation and provides both Bayes Factor
and p-value based testing.
}
\details{
This function implements a multistage MCMC Bayesian approach for
DMR detection. It recursively splits genomic regions and applies Bayesian
testing. This function supports both Bayes Factor and Anderson-Darling tests
for significance assessment. The algorithm begins by analyzing entire chromosomal
regions, then recursively splits significant regions into smaller sub-regions
for analysis, stopping when either maximum stages reached or no significant 
differences are detected.
}
\examples{
 
\donttest{
# Load the datasets
data(cancer_demo)
data(normal_demo)

priors=list(alpha = 1,mu = 1,sigma2 = 1)

mcmc = list(nburn = 5000, niter = 10000, thin = 5) 

set.seed(2021)
rst <- mmcmcBayes(cancer_demo, normal_demo, 
                 stage = 1,max_stages = 2,num_splits = 5,
                 test = "BF", priors_cancer = NULL, priors_normal = NULL,
                 bf_thresholds = list(stage1 = 10, stage2 = 10.3, stage3 = 10.3),
                 return_mcmc = TRUE)
print(rst$dmrs)
}

}
\seealso{
Helper functions in this package:
\code{\link{asgn_func}} for parameter estimation,
\code{\link{traceplot_asgn}} for MCMC diagnostics,
\code{\link{compare_dmrs}} for result comparison
}
\author{
Zhexuan Yang, Duchwan Ryu, and Feng Luan
}
